/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.impl.Compiler;
import com.day.cq.widget.impl.CompilerContext;
import com.day.cq.widget.impl.CompilerProvider;
import com.day.cq.widget.impl.JcrPropertyResource;
import com.day.cq.widget.impl.JcrResourceProvider;
import com.day.cq.widget.impl.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBundle {
    private static final String PN_DEPENDENCIES = "dependencies";
    private static final Logger log = LoggerFactory.getLogger(FileBundle.class);
    private final CompiledScript files;
    private final String rootPath;
    private final String filePrefix;
    private boolean dirty;

    public FileBundle(Node root, String includeFileName, String filePrefix) throws RepositoryException {
        this.filePrefix = filePrefix == null ? "" : filePrefix;
        this.rootPath = root.getPath();
        this.files = new CompiledScript(this.rootPath, 0L, "");
        try {
            if (root.hasNode(includeFileName)) {
                this.scanIncludeList(root, includeFileName);
            } else {
                this.scanFiles(root);
            }
        }
        catch (Exception e) {
            log.error("Error occurred while scanning files for: " + this.files.getPath(), (Throwable)e);
        }
        log.debug("getFiles(): {} files found", (Object)this.files.getScripts().size());
    }

    public Set<String> getFiles() {
        return this.files.getScripts().keySet();
    }

    public void addSourcePaths(Set<String> sourcePaths) {
        this.files.dumpDependencies(sourcePaths);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public long getLastModified() {
        return this.files.getLastModified();
    }

    public void addResources(Session session, CompilerProvider provider, List<Resource> resources) throws RepositoryException {
        try {
            this.files.refresh(session, provider);
            this.files.addScriptsAsResources(session, resources);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanIncludeList(Node root, String fileName) throws RepositoryException, IOException {
        Node includeFile = root.getNode(fileName);
        Script includeScript = this.createScript(includeFile);
        this.files.addScript(includeScript, true);
        BufferedReader reader = new BufferedReader(includeScript.getResource(root.getSession()).getReader());
        try {
            String line;
            String basePath = this.rootPath + this.filePrefix;
            while ((line = reader.readLine()) != null) {
                Node node;
                String path = line.trim();
                if (path.length() == 0 || path.startsWith("#")) {
                    if (!path.startsWith("#base=") || (basePath = path.substring(6)).startsWith("/")) continue;
                    basePath = this.rootPath + this.filePrefix + "/" + basePath;
                    continue;
                }
                if (!path.startsWith("/")) {
                    path = basePath + "/" + path;
                }
                if (!root.getSession().itemExists(path)) {
                    log.warn("Referenced path in {} does not exist: {}", (Object)includeScript.getPath(), (Object)path);
                    continue;
                }
                if (path.startsWith("/libs/")) {
                    String altPath = "/apps/" + path.substring(6);
                    if (root.getSession().nodeExists(altPath)) {
                        log.info("Library file {} overlayed by {}.", (Object)path, (Object)altPath);
                        path = altPath;
                    }
                }
                if (!(node = root.getSession().getNode(path)).hasProperty("jcr:content/jcr:data")) {
                    log.warn("Referenced node has no data: {}", (Object)path);
                    continue;
                }
                this.files.addScript(this.createScript(node), false);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private Script createScript(Node node) throws RepositoryException {
        String path = node.getPath();
        long lastMod = FileBundle.getLastModified(node);
        FileScript s = new FileScript(path, lastMod);
        if (path.endsWith(".less")) {
            String name = Text.getName((String)path);
            String generatedPath = Text.getRelativeParent((String)path, (int)1) + "/generated/" + name.substring(0, name.lastIndexOf(46)) + ".css";
            Node generatedNode = null;
            long generatedLastMod = 0L;
            Session session = node.getSession();
            if (session.nodeExists(generatedPath)) {
                generatedNode = session.getNode(generatedPath);
                generatedLastMod = FileBundle.getLastModified(generatedNode);
            }
            CompiledScript cs = new CompiledScript(generatedPath, generatedLastMod, "less");
            cs.addScript(s, false);
            if (generatedNode != null && generatedNode.hasProperty("{http://www.jcp.org/jcr/1.0}content/dependencies")) {
                for (Value v : generatedNode.getProperty("{http://www.jcp.org/jcr/1.0}content/dependencies").getValues()) {
                    String depPath = v.getString();
                    if (!session.nodeExists(depPath)) continue;
                    Node depNode = session.getNode(depPath);
                    long depLastMod = FileBundle.getLastModified(depNode);
                    FileScript depScript = new FileScript(depPath, depLastMod);
                    cs.addScript(depScript, true);
                }
            }
            s = cs;
        }
        return s;
    }

    private static long getLastModified(Node fileNode) {
        try {
            if (fileNode.hasProperty("jcr:content/jcr:lastModified")) {
                return fileNode.getProperty("jcr:content/jcr:lastModified").getLong();
            }
        }
        catch (RepositoryException e) {
            log.error("Error while updating last modified time for file: {}", (Object)fileNode);
        }
        return 0L;
    }

    private void scanFiles(Node parent) throws RepositoryException {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.isNodeType("nt:file")) {
                this.files.addScript(this.createScript(node), false);
                continue;
            }
            if (!node.isNodeType("nt:folder")) continue;
            this.scanFiles(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompiledScript
    extends FileScript {
        private final String compilerName;
        private long compiledLastModified;
        private final LinkedHashMap<String, Script> files = new LinkedHashMap();
        private Collection<String> dependencies = new HashSet<String>();

        private CompiledScript(String path, long lastModified, String compiler) {
            super(path, 0L);
            this.compiledLastModified = lastModified;
            this.compilerName = compiler;
        }

        public void addScript(Script s, boolean transitive) {
            this.touch(s.getLastModified());
            if (transitive) {
                this.dependencies.add(s.getPath());
            } else {
                this.files.put(s.getPath(), s);
            }
        }

        public void touch(long lastMod) {
            if (lastMod > this.lastModified) {
                this.lastModified = lastMod;
            }
        }

        public Map<String, Script> getScripts() {
            return this.files;
        }

        public void addScriptsAsResources(Session session, List<Resource> resources) throws RepositoryException {
            for (Script s : this.files.values()) {
                resources.add(s.getResource(session));
            }
        }

        @Override
        public void refresh(Session session, CompilerProvider compilerProvider) throws RepositoryException, IOException {
            if (this.lastModified > this.compiledLastModified) {
                for (Script s : this.files.values()) {
                    s.refresh(session, compilerProvider);
                    this.touch(s.getLastModified());
                }
                Compiler compiler = compilerProvider.getCompiler(this.compilerName);
                if (compiler != null) {
                    Node content;
                    if (session.nodeExists(this.path)) {
                        content = session.getNode(this.path + "/" + "jcr:content");
                    } else {
                        Node fileNode = JcrUtils.getOrCreateByPath((String)this.path, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}file", (Session)session, (boolean)false);
                        content = fileNode.addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "utf-8");
                    LinkedList<Resource> resources = new LinkedList<Resource>();
                    this.addScriptsAsResources(session, resources);
                    CompilerContext ctx = new CompilerContext(new JcrResourceProvider(session), this.path);
                    compiler.compile(resources, w, ctx);
                    ((Writer)w).close();
                    Binary bin = session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(out.toByteArray()));
                    content.setProperty("jcr:data", bin);
                    bin.dispose();
                    content.setProperty("jcr:lastModified", this.lastModified);
                    content.setProperty("jcr:mimeType", compiler.getMimeType());
                    this.dependencies = ctx.getDependencies();
                    try {
                        content.setProperty(FileBundle.PN_DEPENDENCIES, this.dependencies.toArray(new String[this.dependencies.size()]));
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to update dependency list.", (Throwable)e);
                    }
                }
                this.compiledLastModified = this.lastModified;
            }
        }

        @Override
        public void dumpDependencies(Set<String> deps) {
            super.dumpDependencies(deps);
            for (Script s : this.files.values()) {
                s.dumpDependencies(deps);
            }
            deps.addAll(this.dependencies);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileScript
    implements Script {
        protected final String path;
        protected long lastModified;

        private FileScript(String path, long lastModified) {
            this.path = path;
            this.lastModified = lastModified;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public Resource getResource(Session session) throws RepositoryException {
            Property p = session.getProperty(this.path + "/jcr:content/jcr:data");
            return new JcrPropertyResource(p, p.getParent().getParent().getPath());
        }

        @Override
        public void refresh(Session s, CompilerProvider compiler) throws RepositoryException, IOException {
        }

        @Override
        public void dumpDependencies(Set<String> deps) {
            deps.add(this.path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Script {
        public String getPath();

        public long getLastModified();

        public Resource getResource(Session var1) throws RepositoryException;

        public void refresh(Session var1, CompilerProvider var2) throws RepositoryException, IOException;

        public void dumpDependencies(Set<String> var1);
    }
}

