/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.ClientLibraryImpl;
import com.day.cq.widget.impl.FileBundle;
import com.day.cq.widget.impl.HtmlLibraryManagerImpl;
import com.day.text.Text;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLibraryImpl
implements HtmlLibrary {
    private final String path;
    private final String minifiedPath;
    private final String rootPath;
    private final LibraryType type;
    private final FileBundle bundle;
    private final FileBundle[] embedded;
    private final HtmlLibraryManagerImpl mgr;

    protected HtmlLibraryImpl(HtmlLibraryManagerImpl mgr, ClientLibraryImpl library, LibraryType type, FileBundle bundle, FileBundle[] embedded) {
        this.type = type;
        this.rootPath = bundle.getRootPath();
        this.path = library.getIncludePath(type);
        this.minifiedPath = library.getIncludePath(type, true);
        this.bundle = bundle;
        this.embedded = embedded;
        this.mgr = mgr;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPath(boolean minified) {
        return minified ? this.minifiedPath : this.path;
    }

    @Override
    public String getName() {
        return Text.getName((String)this.path);
    }

    @Override
    public String getName(boolean minified) {
        return minified ? Text.getName((String)this.minifiedPath) : Text.getName((String)this.path);
    }

    @Override
    public String getLibraryPath() {
        return this.rootPath;
    }

    @Override
    public LibraryType getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.getLastModified(false);
    }

    @Override
    public long getLastModified(boolean minified) {
        return this.mgr.getLastModified(this, minified);
    }

    @Override
    public void send(HttpServletResponse response, boolean gzip) throws IOException {
        this.mgr.send(this, response, gzip, false);
    }

    @Override
    public void send(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String[] selectors = request.getRequestPathInfo().getSelectors();
        boolean minified = selectors != null && selectors.length > 0 && "min".equals(selectors[0]);
        this.mgr.send(this, request, response, minified);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getInputStream(false);
    }

    @Override
    public InputStream getInputStream(boolean minified) throws IOException {
        return this.mgr.getInputStream(this, minified);
    }

    public FileBundle getBundle() {
        return this.bundle;
    }

    public long getBundleLastModified() {
        long lm = this.bundle.getLastModified();
        if (this.embedded != null) {
            for (FileBundle e : this.embedded) {
                if (e.getLastModified() <= lm) continue;
                lm = e.getLastModified();
            }
        }
        return lm;
    }

    public FileBundle[] getEmbedded() {
        return this.embedded;
    }

    @Override
    public List<String> getScripts() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.embedded != null) {
            for (FileBundle bundle : this.embedded) {
                for (String path : bundle.getFiles()) {
                    list.add(path);
                }
            }
        }
        for (String path : this.bundle.getFiles()) {
            list.add(path);
        }
        return list;
    }

    @Override
    public String getScripts(String delimiter) {
        String d = "";
        StringBuilder scripts = new StringBuilder();
        for (String path : this.getScripts()) {
            scripts.append(d).append("\"").append(path).append("\"");
            d = delimiter;
        }
        return scripts.toString();
    }
}

