/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import com.day.cq.widget.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"widgets/clientlib", "cq/ClientLibraryFolder"}, propertyPrivate=true), @Property(name="service.description", value={"service.description"}, propertyPrivate=true)})
public class HtmlLibraryServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(HtmlLibraryServlet.class);
    private static final String DEBUG = "debug";
    private static final int MAX_CSS_FILES_TO_INCLUDE = 31;
    @Reference
    protected HtmlLibraryManager libMgr;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        try {
            HtmlLibrary library = this.libMgr.getLibrary(request);
            if (library == null) {
                response.sendError(404);
                return;
            }
            if (HtmlLibraryServlet.isDebug(request)) {
                log.debug("Creating {} debug library for {}", (Object)library.getType(), (Object)library.getLibraryPath());
                if (library.getType() == LibraryType.JS) {
                    HtmlLibraryServlet.createJsDebugScript(library, request, response, false);
                } else {
                    HtmlLibraryServlet.createCssDebugScript(library, request, response, false);
                }
                log.debug("Created {} debug library for {}", (Object)library.getType(), (Object)library.getLibraryPath());
            } else {
                library.send(request, response);
            }
        }
        catch (Exception e) {
            log.error("Cannot create library for {}", (Object)request.getRequestURI(), (Object)e);
            response.sendError(404);
        }
    }

    protected static boolean isDebug(SlingHttpServletRequest request) {
        return "true".equals(request.getParameter(DEBUG));
    }

    protected static String getLoaderScript() throws IOException {
        InputStream is = HtmlLibraryServlet.class.getResourceAsStream("/com/day/cq/widget/Loader.js");
        return IOUtils.toString((InputStream)is);
    }

    protected static void createJsDebugScript(HtmlLibrary library, SlingHttpServletRequest request, SlingHttpServletResponse response, boolean proxy) throws Exception {
        response.setContentType("application/x-javascript");
        StringBuilder scriptList = new StringBuilder();
        String delim = "";
        for (String script : library.getScripts()) {
            scriptList.append(delim).append('\"');
            if (proxy && (script.startsWith("/libs/") || script.startsWith("/apps/"))) {
                scriptList.append("/etc.clientlibs").append(script.substring(5));
            } else {
                scriptList.append(script);
            }
            scriptList.append('\"');
            delim = "\n,";
        }
        String loaderScript = HtmlLibraryServlet.getLoaderScript();
        loaderScript = loaderScript.replaceAll("__JS_FILES__", scriptList.toString());
        loaderScript = loaderScript.replaceAll("__RESOURCE_PATH__", request.getContextPath());
        response.getWriter().write(loaderScript);
    }

    protected static void createCssDebugScript(HtmlLibrary library, SlingHttpServletRequest request, SlingHttpServletResponse response, boolean proxy) throws Exception {
        response.setContentType(library.getType().contentType);
        List<String> cssFiles = library.getScripts();
        if (cssFiles.size() > 31 && request.getRequestPathInfo().getSelectors().length == 0) {
            int slices = cssFiles.size() / 31;
            ServletOutputStream out = response.getOutputStream();
            String libPath = library.getLibraryPath();
            if (proxy && (libPath.startsWith("/libs/") || libPath.startsWith("/apps/"))) {
                libPath = "/etc.clientlibs" + libPath.substring(5);
            }
            for (int i = 0; i <= slices; ++i) {
                int slice = i * 31;
                out.println("@import url(\"" + request.getContextPath() + libPath + "." + slice + ".css?debug=true\");");
            }
        } else {
            int offset = 0;
            if (request.getRequestPathInfo().getSelectors().length > 0) {
                offset = Integer.valueOf(request.getRequestPathInfo().getSelectors()[0]);
            }
            int len = Math.min(cssFiles.size(), offset + 31);
            for (int i = offset; i < len; ++i) {
                String cssFile = cssFiles.get(i);
                if (proxy && (cssFile.startsWith("/libs/") || cssFile.startsWith("/apps/"))) {
                    cssFile = "/etc.clientlibs" + cssFile.substring(5);
                }
                response.getOutputStream().println("@import url(\"" + request.getContextPath() + cssFile + "\");");
            }
            log.debug("Included from " + offset + " to " + len);
        }
    }

    protected void bindLibMgr(HtmlLibraryManager htmlLibraryManager) {
        this.libMgr = htmlLibraryManager;
    }

    protected void unbindLibMgr(HtmlLibraryManager htmlLibraryManager) {
        if (this.libMgr == htmlLibraryManager) {
            this.libMgr = null;
        }
    }
}

