/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.impl.Resource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class JcrPropertyResource
implements Resource {
    private final Property data;
    private final String name;

    public JcrPropertyResource(Property data, String name) {
        this.name = name;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        try {
            return this.data.getLength();
        }
        catch (RepositoryException e) {
            return -1L;
        }
    }

    public Property getData() {
        return this.data;
    }

    public String getEncoding() {
        String encoding = "utf-8";
        try {
            if (this.data.getParent().hasProperty("{http://www.jcp.org/jcr/1.0}encoding")) {
                encoding = this.data.getParent().getProperty("{http://www.jcp.org/jcr/1.0}encoding").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return encoding;
    }

    public Reader getReader() throws IOException {
        try {
            return new InputStreamReader(this.data.getBinary().getStream(), this.getEncoding());
        }
        catch (RepositoryException e) {
            IOException io = new IOException("Unable to provide data stream.");
            io.initCause(e);
            throw io;
        }
    }
}

