/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.impl.JcrPropertyResource;
import com.day.cq.widget.impl.Resource;
import com.day.cq.widget.impl.ResourceProvider;
import java.io.IOException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JcrResourceProvider
implements ResourceProvider {
    private final Session session;

    public JcrResourceProvider(Session session) {
        this.session = session;
    }

    public Resource getResource(String path) throws IOException {
        try {
            String propPath = path + "/jcr:content/jcr:data";
            if (this.session.propertyExists(propPath)) {
                Property p = this.session.getProperty(propPath);
                return new JcrPropertyResource(p, p.getParent().getParent().getPath());
            }
            return null;
        }
        catch (RepositoryException e) {
            IOException io = new IOException("Unable to read resource at " + path);
            io.initCause(e);
            throw io;
        }
    }
}

