/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.LibraryType;
import com.day.cq.widget.impl.AbstractBuilder;
import com.day.cq.widget.impl.Resource;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFileBuilder
extends AbstractBuilder {
    private static final Logger log = LoggerFactory.getLogger(JsFileBuilder.class);
    private static final int lineBreakPos = 0;
    private static final boolean warn = false;
    private static final boolean munge = true;
    private static final boolean preserveAllSemiColons = false;
    private static final boolean disableOptimizationsOpt = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String concatenate(Collection<Resource> resources) throws IOException {
        StringWriter out = new StringWriter();
        for (Resource resource : resources) {
            Reader r = null;
            try {
                r = resource.getReader();
                IOUtils.copy((Reader)r, (Writer)out);
            }
            finally {
                IOUtils.closeQuietly((Reader)r);
            }
            out.append("\n");
        }
        return out.toString();
    }

    @Override
    protected String minify(String source) throws IOException {
        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), new ErrorReporter(){

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (line < 0) {
                    log.debug("\n[WARNING] " + message);
                } else {
                    log.debug("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
                    log.debug("\n[WARNING] " + lineSource);
                }
            }

            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (line < 0) {
                    log.error("\n[ERROR] " + message);
                } else {
                    log.error("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
                    log.error("\n[ERROR] " + lineSource);
                }
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                this.error(message, sourceName, line, lineSource, lineOffset);
                return new EvaluatorException(message);
            }
        });
        StringWriter out = new StringWriter(source.length());
        compressor.compress((Writer)out, 0, true, false, false, false);
        return out.toString();
    }

    @Override
    public LibraryType getType() {
        return LibraryType.JS;
    }
}

