/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.impl.Compiler;
import com.day.cq.widget.impl.CompilerContext;
import com.day.cq.widget.impl.CssFileBuilder;
import com.day.cq.widget.impl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jackrabbit.util.Text;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessCompilerImpl
implements Compiler {
    protected static final Logger log = LoggerFactory.getLogger(LessCompilerImpl.class);
    private Script envJs;
    private Script lessJs;
    private boolean includeSourceMarkers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LessCompilerImpl() {
        Context cx = Context.enter();
        try {
            long t0 = System.currentTimeMillis();
            cx.setOptimizationLevel(-1);
            this.envJs = this.processSource(cx, "/com/day/cq/widget/less/env.rhino.js");
            cx.setOptimizationLevel(9);
            this.lessJs = this.processSource(cx, "/com/day/cq/widget/less/less-1.3.3.js");
            long t1 = System.currentTimeMillis();
            log.info("Initialized LessCompiler in {}ms", (Object)(t1 - t0));
        }
        catch (IOException e) {
            log.error("Error while loading sources.", (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    public boolean isIncludeSourceMarkers() {
        return this.includeSourceMarkers;
    }

    public void setIncludeSourceMarkers(boolean includeSourceMarkers) {
        this.includeSourceMarkers = includeSourceMarkers;
    }

    @Override
    public String getName() {
        return "less";
    }

    @Override
    public String getMimeType() {
        return "text/css";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compile(Collection<Resource> src, Writer dst, CompilerContext ctx) throws IOException {
        try {
            Context cx = Context.enter();
            long t0 = System.currentTimeMillis();
            JsTestGlobalScope globalScope = new JsTestGlobalScope();
            cx.initStandardObjects((ScriptableObject)globalScope);
            String[] names = new String[]{"print"};
            globalScope.defineFunctionProperties(names, LessCompilerImpl.class, 4);
            globalScope.put("jcrConnectionHandler", (Scriptable)globalScope, new ConnectionHandler(ctx));
            this.envJs.exec(cx, (Scriptable)globalScope);
            this.lessJs.exec(cx, (Scriptable)globalScope);
            long t1 = System.currentTimeMillis();
            log.info("Setup less compiler environment in {}ms", (Object)(t1 - t0));
            for (Resource r : src) {
                log.info("Compiling {}...", (Object)r.getName());
                String less = LessCompilerImpl.retrieveInputString(r);
                if (log.isDebugEnabled()) {
                    log.debug("less source: {}", (Object)less);
                }
                try {
                    t1 = System.currentTimeMillis();
                    globalScope.put("lessSourceCode", (Scriptable)globalScope, less);
                    String js = String.format("document.baseURI = '/';var result=''; var lesserror;var p = new less.Parser({paths:['%s/'], filename: '%s'});p.parse(lessSourceCode, function(e, tree){if (e) {lesserror = e;} else {result=tree.toCSS(); }});", StringEscapeUtils.escapeJavaScript((String)Text.getRelativeParent((String)r.getName(), (int)1)), Text.getName((String)r.getName()));
                    cx.evaluateString((Scriptable)globalScope, js, "generated.js", 1, null);
                    long t2 = System.currentTimeMillis();
                    Object result = globalScope.get("result", (Scriptable)globalScope);
                    Object lesserror = globalScope.get("lesserror", (Scriptable)globalScope);
                    if (result instanceof Undefined) {
                        this.dumpError(dst, r.getName(), "result was Undefined", less);
                        continue;
                    }
                    if (!(lesserror instanceof Undefined)) {
                        String message = this.getErrorMessage(lesserror);
                        this.dumpError(dst, r.getName(), message, less);
                        continue;
                    }
                    String css = result.toString();
                    css = css.replace("\\n", "\n");
                    css = CssFileBuilder.rewriteUrlsInCss(ctx.getDestinationPath(), r.getName(), css);
                    if (log.isDebugEnabled()) {
                        log.debug("compiled output is: {}", (Object)css);
                    }
                    if (this.includeSourceMarkers) {
                        dst.write(String.format("/*---------------------------------------------------------------< %s >---*/%n", Text.getName((String)r.getName())));
                        dst.write(String.format("/* %s (%dms) */%n", r.getName(), t2 - t1));
                    }
                    dst.write(css);
                }
                catch (JavaScriptException ex) {
                    String message;
                    try {
                        message = this.getErrorMessage(ex.getValue());
                    }
                    catch (Exception e) {
                        message = "[could not determine error message]";
                    }
                    log.error("failed to compile {}: {} exception:{}", new Object[]{r.getName(), message, ex});
                    this.dumpError(dst, r.getName(), message, less);
                }
                catch (Exception ex) {
                    log.error("unexpected error during compile", (Throwable)ex);
                }
            }
        }
        finally {
            Context.exit();
        }
    }

    private void dumpError(Writer out, String name, String message, String lessSrc) throws IOException {
        log.error("failed to compile less {}: {}", (Object)name, (Object)message);
        out.write("/*****************************************************\n");
        out.write("LESS compilation failed due a JavaScript error!\n\n");
        out.write("Input: " + name + "\n");
        out.write("Error: " + message + "\n\n");
        out.write("(uncompiled LESS src is included below)\n");
        out.write("*****************************************************/\n");
        out.write(lessSrc);
    }

    private String getErrorMessage(Object object) {
        return (String)NativeObject.getProperty((Scriptable)((Scriptable)object), (String)"message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script processSource(Context cx, String resourcePath) throws IOException {
        Script script;
        InputStreamReader in = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            in = new InputStreamReader(is);
            script = cx.compileReader((Reader)in, resourcePath, 0, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return script;
    }

    public static void print(String msg) {
        log.info("{}", (Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveInputString(Resource r) throws IOException {
        String src = "";
        Reader in = r.getReader();
        try {
            src = IOUtils.toString((Reader)in);
            src = src.replace("\r", "");
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return src;
    }

    public static class ConnectionHandler {
        private final CompilerContext ctx;

        public ConnectionHandler(CompilerContext ctx) {
            this.ctx = ctx;
        }

        public void handle(Object obj) {
            block8: {
                if (obj instanceof ScriptableObject) {
                    ScriptableObject xhr = (ScriptableObject)obj;
                    String path = xhr.get("url", (Scriptable)xhr).toString();
                    if (!path.startsWith("/")) {
                        log.warn("Only absolute paths supported in @import statements.");
                        xhr.put("readyState", (Scriptable)xhr, (Object)4);
                        xhr.put("status", (Scriptable)xhr, (Object)404);
                        xhr.put("statusText", (Scriptable)xhr, (Object)"Only absolute paths supported in @import statements.");
                        log.warn("Only absolute paths supported in @import statements: {}", (Object)path);
                    } else {
                        String name = Text.getName((String)path);
                        String ext = Text.getName((String)name, (char)'.');
                        if (ext.length() == 0) {
                            path = path + ".less";
                        }
                        try {
                            Resource r = this.ctx.getResourceProvider().getResource(path);
                            if (r == null) {
                                xhr.put("readyState", (Scriptable)xhr, (Object)4);
                                xhr.put("status", (Scriptable)xhr, (Object)404);
                                xhr.put("statusText", (Scriptable)xhr, (Object)"");
                                log.warn("Resource referenced in @import statement not defined: {}", (Object)path);
                                break block8;
                            }
                            xhr.put("readyState", (Scriptable)xhr, (Object)4);
                            xhr.put("status", (Scriptable)xhr, (Object)200);
                            xhr.put("statusText", (Scriptable)xhr, (Object)"ok");
                            xhr.put("responseText", (Scriptable)xhr, (Object)LessCompilerImpl.retrieveInputString(r));
                            this.ctx.getDependencies().add(path);
                        }
                        catch (Exception e) {
                            log.error("Error while loading @import resource {}", (Object)path, (Object)e);
                            xhr.put("readyState", (Scriptable)xhr, (Object)4);
                            xhr.put("status", (Scriptable)xhr, (Object)500);
                            xhr.put("statusText", (Scriptable)xhr, (Object)e.getMessage());
                        }
                    }
                } else {
                    log.warn("Unknown object {}", obj);
                }
            }
        }
    }

    private static class JsTestGlobalScope
    extends ScriptableObject {
        private JsTestGlobalScope() {
        }

        public String getClassName() {
            return "global";
        }
    }
}

