/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.widget.impl;

import com.day.cq.widget.ClientLibrary;
import com.day.cq.widget.impl.ClientLibraryImpl;
import com.day.text.Text;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryCacheImpl {
    private static final Logger log = LoggerFactory.getLogger(LibraryCacheImpl.class);
    private static final Comparator<String> REV_PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return Text.compareHandles((String)o2, (String)o1);
        }
    };
    private final Map<String, Map<String, ClientLibraryImpl>> libsByCategory = new TreeMap<String, Map<String, ClientLibraryImpl>>();
    private final Map<String, ClientLibraryImpl> libsByPath = new TreeMap<String, ClientLibraryImpl>();
    private final Map<String, Set<String>> libsPathsBySource = new HashMap<String, Set<String>>();
    private final Set<String> ancestorPaths = new HashSet<String>();

    public void clear() {
        this.libsByCategory.clear();
        this.libsByPath.clear();
        this.libsPathsBySource.clear();
        this.ancestorPaths.clear();
    }

    public ClientLibraryImpl getLibrary(String path) {
        return this.libsByPath.get(path);
    }

    public Map<String, ClientLibrary> getLibraries() {
        TreeMap<String, ClientLibraryImpl> libs = new TreeMap<String, ClientLibraryImpl>();
        for (ClientLibraryImpl lib : this.libsByPath.values()) {
            libs.put(lib.getPath(), lib.createCopy());
        }
        for (ClientLibraryImpl lib : libs.values()) {
            lib.relink(libs);
        }
        return new TreeMap<String, ClientLibrary>((Map<String, ClientLibrary>)libs);
    }

    public boolean isAncestor(String path) {
        return this.ancestorPaths.contains(path);
    }

    public Set<String> getLibsPathsFromSource(String path) {
        return this.libsPathsBySource.get(path);
    }

    public Map<String, ClientLibraryImpl> getLibsByCategory(String[] categories) {
        LinkedHashMap<String, ClientLibraryImpl> entries = new LinkedHashMap<String, ClientLibraryImpl>();
        for (String category : categories) {
            Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(category);
            if (libs == null) continue;
            for (ClientLibraryImpl e : libs.values()) {
                if (entries.containsKey(e.getPath())) continue;
                entries.put(e.getPath(), e);
            }
        }
        return entries;
    }

    public void rebuildAncestorPaths() {
        this.ancestorPaths.clear();
        for (String p : this.libsByPath.keySet()) {
            p = org.apache.jackrabbit.util.Text.getRelativeParent((String)p, (int)1);
            while (p.length() > 1) {
                this.ancestorPaths.add(p);
                p = org.apache.jackrabbit.util.Text.getRelativeParent((String)p, (int)1);
            }
        }
        log.info("Rebuilt {} ancestor paths", (Object)this.ancestorPaths.size());
        if (log.isDebugEnabled()) {
            for (String p : this.ancestorPaths) {
                log.debug("- {}", (Object)p);
            }
        }
    }

    public void addSourcePaths(ClientLibraryImpl lib) {
        String path = lib.getPath();
        for (String depPath : lib.getSourcePaths()) {
            Set<String> depEntry = this.libsPathsBySource.get(depPath);
            if (depEntry == null) {
                depEntry = new HashSet<String>();
                this.libsPathsBySource.put(depPath, depEntry);
            }
            depEntry.add(path);
        }
    }

    public void removeSourcePaths(ClientLibraryImpl lib) {
        String path = lib.getPath();
        for (String depPath : lib.getSourcePaths()) {
            Set<String> depSet = this.libsPathsBySource.get(depPath);
            if (depSet == null) continue;
            depSet.remove(path);
        }
    }

    public void add(ClientLibraryImpl lib) {
        this.libsByPath.put(lib.getPath(), lib);
        this.addSourcePaths(lib);
        for (String category : lib.getCategories()) {
            log.debug("assigned category {}", (Object)category);
            Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(category);
            if (libs == null) {
                libs = new TreeMap<String, ClientLibraryImpl>(REV_PATH_COMPARATOR);
                this.libsByCategory.put(category, libs);
            }
            libs.put(lib.getPath(), lib);
        }
    }

    public void remove(String path) {
        ClientLibraryImpl e = this.libsByPath.remove(path);
        if (e != null) {
            log.info("Invalidating library {}", (Object)path);
            for (String tag : e.getCategories()) {
                Map<String, ClientLibraryImpl> libs = this.libsByCategory.get(tag);
                if (libs == null) continue;
                libs.remove(path);
            }
            this.removeSourcePaths(e);
        }
    }

    public void resolveLibraries() {
        for (ClientLibraryImpl lib : this.libsByPath.values()) {
            lib.clear();
        }
        HashSet<String> processed = new HashSet<String>();
        LinkedList<String> paths = new LinkedList<String>(this.libsByPath.keySet());
        while (!paths.isEmpty()) {
            this.resolveLib(processed, (String)paths.remove(0));
        }
    }

    private ClientLibraryImpl resolveLib(Set<String> processed, String path) {
        ClientLibraryImpl lib = this.libsByPath.get(path);
        if (lib != null && !processed.contains(path)) {
            processed.add(path);
            for (String depPath : this.getLibsByCategory(lib.getDependentCategories()).keySet()) {
                ClientLibraryImpl dep = this.resolveLib(processed, depPath);
                if (dep == null) continue;
                lib.addDependency(dep);
            }
            LinkedHashMap<String, ClientLibraryImpl> embedded = new LinkedHashMap<String, ClientLibraryImpl>();
            for (String depPath : this.getLibsByCategory(lib.getEmbeddedCategories()).keySet()) {
                ClientLibraryImpl dep = this.resolveLib(processed, depPath);
                if (dep == null) continue;
                embedded.put(dep.getPath(), dep);
            }
            while (!embedded.isEmpty()) {
                this.addEmbedded(lib, embedded, (String)embedded.keySet().iterator().next());
            }
        }
        return lib;
    }

    private void addEmbedded(ClientLibraryImpl lib, Map<String, ClientLibraryImpl> embeddeds, String path) {
        ClientLibraryImpl emb = embeddeds.remove(path);
        if (emb != null) {
            for (String depPath : emb.getDependencies(false).keySet()) {
                this.addEmbedded(lib, embeddeds, depPath);
            }
            lib.addEmbedded(emb);
        }
    }

    public void logStatus() {
        log.info("Cache contains {} libraries, sourced from {} files.", (Object)this.libsByPath.size(), (Object)this.libsPathsBySource.size());
    }
}

