/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Field;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class BulkEditValueMap
implements ValueMap {
    private List<Resource> resources;
    private HashMap<String, MergedValue> cache;

    public BulkEditValueMap(List<Resource> resources) {
        this.resources = resources;
        this.cache = new HashMap();
    }

    public Object get(Object key) {
        String keyName = (String)key;
        if (keyName.endsWith(Field.IS_MIXED_SUFFIX)) {
            keyName = keyName.replace(Field.IS_MIXED_SUFFIX, "");
            return this.isValueMixed(keyName);
        }
        return this.getValue(keyName);
    }

    public <T> T get(String name, Class<T> type) {
        if (type == null) {
            return (T)this.get(name);
        }
        return this.convert(this.get(name), type);
    }

    public <T> T get(String name, T defaultValue) {
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    private Object getValue(String key) {
        return this.fetchMergedValue(key).getValue();
    }

    private boolean isValueMixed(String key) {
        return this.fetchMergedValue(key).isMixed();
    }

    private MergedValue fetchMergedValue(String key) {
        MergedValue mergedValue;
        if (this.cache.containsKey(key)) {
            mergedValue = this.cache.get(key);
        } else {
            List<Object> values = this.fetchValues(key);
            mergedValue = values.size() == 0 ? new MergedValue(null, false) : (values.size() < this.resources.size() ? new MergedValue(null, true) : new MergedValue(values));
            this.cache.put(key, mergedValue);
        }
        return mergedValue;
    }

    private List<Object> fetchValues(String key) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Resource resource : this.resources) {
            Object value = resource.getValueMap().get((Object)key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public boolean containsValue(Object value) {
        return false;
    }

    public Set<String> keySet() {
        return null;
    }

    public Collection<Object> values() {
        return null;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (obj instanceof Calendar && type == String.class) {
                return (T)ISO8601.format((Calendar)((Calendar)obj));
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        LinkedList<T> values = new LinkedList<T>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                values.add(this.convert(o, type));
            }
        } else {
            values.add(this.convert(obj, type));
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private class MergedValue {
        private Object value;
        private boolean isMixed;
        private static final String MIXED_VALUE = "";

        public MergedValue(Object value, boolean isMixed) {
            this.value = value == null ? MIXED_VALUE : value;
            this.isMixed = isMixed;
        }

        public MergedValue(List<Object> values) {
            if (values.get(0).getClass().isArray()) {
                this.doMergeArrayValues(values);
            } else {
                this.doMergeSingleValues(values);
            }
        }

        private void doMergeSingleValues(List<Object> values) {
            Object mergedValue;
            boolean isMixed;
            HashSet<Object> set = new HashSet<Object>(values);
            ArrayList<Object> uniqueValues = new ArrayList<Object>(set);
            if (uniqueValues.size() == 1) {
                isMixed = false;
                mergedValue = values.get(0);
            } else {
                isMixed = true;
                mergedValue = MIXED_VALUE;
            }
            this.isMixed = isMixed;
            this.value = mergedValue;
        }

        private boolean equalsIgnoreOrder(Object[] first, Object[] second) {
            HashSet<Object> firstSet = new HashSet<Object>(Arrays.asList(first));
            HashSet<Object> secondSet = new HashSet<Object>(Arrays.asList(second));
            return firstSet.equals(secondSet);
        }

        private void doMergeArrayValues(List<Object> arrayValues) {
            boolean isMixed = false;
            Object[] previousMerge = null;
            Object[] previousValue = null;
            for (Object arrayValue : arrayValues) {
                Object[] currentValue = (Object[])arrayValue;
                if (previousValue == null) {
                    previousValue = currentValue;
                    previousMerge = currentValue;
                    continue;
                }
                Object[] currentMerge = CollectionUtils.intersection(Arrays.asList(previousMerge), Arrays.asList(currentValue)).toArray();
                if (!this.equalsIgnoreOrder(previousValue, currentValue)) {
                    isMixed = true;
                }
                previousValue = currentValue;
                previousMerge = currentMerge;
            }
            Object[] mergedValue = previousMerge;
            this.isMixed = isMixed;
            this.value = mergedValue;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isMixed() {
            return this.isMixed;
        }
    }
}

