/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.LayoutBuilder;
import com.adobe.granite.ui.components.State;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.impl.BaseComponentHelper;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;

public class ComponentHelper {
    private static final String DEFAULT_LAYOUT_RT = "granite/ui/components/foundation/layouts/container";
    private final BaseComponentHelper base;

    public ComponentHelper(PageContext pageContext) {
        SlingBindings bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        this.base = new BaseComponentHelper(bindings.getSling(), bindings.getRequest(), (SlingHttpServletResponse)new JspSlingHttpServletResponseWrapper(pageContext));
    }

    public I18n getI18n() {
        return this.base.getI18n();
    }

    public XSSAPI getXss() {
        return this.base.getXss();
    }

    public Config getConfig() {
        return this.base.getConfig();
    }

    public Value getValue() {
        return this.base.getValue();
    }

    public ExpressionHelper getExpressionHelper() {
        return this.base.getExpressionHelper();
    }

    public State getState() {
        return this.base.getState();
    }

    public Tag consumeTag() {
        return this.base.consumeTag();
    }

    public Resource consumeLayoutResource() {
        Resource layout = this.getOptions().layoutResource();
        return layout == null ? this.base.getRequest().getResource().getChild(Config.LAYOUT) : layout;
    }

    public void populateCommonAttrs(AttrBuilder attrs) {
        this.base.populateCommonAttrs(attrs);
    }

    public void populateCommonAttrs(AttrBuilder attrs, Resource src) {
        this.base.populateCommonAttrs(attrs, src);
    }

    public Options getOptions() {
        com.adobe.granite.ui.components.Options baseOptions = this.base.getOptions();
        if (Options.class.isAssignableFrom(baseOptions.getClass())) {
            return (Options)baseOptions;
        }
        return new Options().tag(baseOptions.tag()).rootField(baseOptions.rootField());
    }

    public LayoutBuilder getLayout() {
        return LayoutBuilder.from(this.consumeLayoutResource(), DEFAULT_LAYOUT_RT);
    }

    public String getReadOnlyResourceType() {
        return this.base.getReadOnlyResourceType();
    }

    public String getReadOnlyResourceType(Resource resource) {
        return this.base.getReadOnlyResourceType(resource);
    }

    public DataSource getItemDataSource() throws ServletException, IOException {
        return this.base.getItemDataSource();
    }

    public DataSource getItemDataSource(Resource resource) throws ServletException, IOException {
        return this.base.getItemDataSource(resource);
    }

    public DataSource asDataSource(Resource datasource) throws ServletException, IOException {
        return this.base.asDataSource(datasource);
    }

    public DataSource asDataSource(Resource datasource, Resource context) throws ServletException, IOException {
        return this.base.asDataSource(datasource, context);
    }

    public RenderCondition getRenderCondition() throws ServletException, IOException {
        return this.base.getRenderCondition();
    }

    public RenderCondition getRenderCondition(Resource resource) throws ServletException, IOException {
        return this.base.getRenderCondition(resource);
    }

    public RenderCondition getRenderCondition(Resource resource, boolean cache) throws ServletException, IOException {
        return this.base.getRenderCondition(resource, cache);
    }

    public String getIconClass(String icon) {
        if (icon == null) {
            return null;
        }
        if (!icon.startsWith("icon-")) {
            return icon;
        }
        return "coral-Icon--" + ComponentHelper.toCamel(icon.substring(5));
    }

    private static String toCamel(String s) {
        String[] parts = s.split("-");
        StringBuilder b = new StringBuilder();
        b.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            b.append(parts[i].substring(0, 1).toUpperCase());
            b.append(parts[i].substring(1));
        }
        return b.toString();
    }

    private static String getResourceType(Resource resource) {
        return new Config(resource).get("sling:resourceType", String.class);
    }

    public void include(Resource resource, Tag tag) throws ServletException, IOException {
        this.include(resource, null, tag);
    }

    public void include(Resource resource, Options options) throws ServletException, IOException {
        this.include(resource, null, options);
    }

    public void include(Resource resource, String resourceType, Tag tag) throws ServletException, IOException {
        this.include(resource, resourceType, new Options().tag(tag));
    }

    public void include(Resource resource, String resourceType, Options options) throws ServletException, IOException {
        this.include(resource, resourceType, null, options);
    }

    public void include(Resource resource, String resourceType, String selectors, Options options) throws ServletException, IOException {
        this.base.include(resource, resourceType, selectors, options);
    }

    public void includeForLayout(Resource resource, Options options) throws ServletException, IOException {
        this.includeForLayout(resource, null, options);
    }

    public void includeForLayout(Resource resource, Resource layoutResource, Options options) throws ServletException, IOException {
        String resourceType = null;
        if (layoutResource == null) {
            Resource r = resource.getChild(Config.LAYOUT);
            if (r != null) {
                resourceType = ComponentHelper.getResourceType(r);
            }
        } else {
            resourceType = ComponentHelper.getResourceType(layoutResource);
            options.layoutResource(layoutResource);
        }
        if (resourceType == null) {
            resourceType = DEFAULT_LAYOUT_RT;
        }
        this.include(resource, resourceType, options);
    }

    public void call(String script, Options options) throws ServletException, IOException {
        this.base.call(script, options);
    }

    public static class Options
    extends com.adobe.granite.ui.components.Options {
        private Resource layout;

        @Override
        public Options tag(Tag tag) {
            super.tag(tag);
            return this;
        }

        @Override
        public Options rootField(boolean flag) {
            super.rootField(flag);
            return this;
        }

        public Resource layoutResource() {
            return this.layout;
        }

        public Options layoutResource(Resource r) {
            this.layout = r;
            return this;
        }
    }
}

