/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;

public class ExpressionHelper {
    private ExpressionResolver resolver;
    private SlingHttpServletRequest request;

    public ExpressionHelper(ExpressionResolver resolver, PageContext pageContext) {
        this(resolver, ExpressionHelper.toSlingRequest(pageContext.getRequest()));
    }

    public ExpressionHelper(ExpressionResolver resolver, SlingHttpServletRequest servletRequest) {
        this.resolver = resolver;
        this.request = servletRequest;
    }

    public String getString(String expression) {
        return this.get(expression, String.class);
    }

    public String getString(String expression, Locale locale) {
        return this.get(expression, locale, String.class);
    }

    public boolean getBoolean(String expression) {
        return this.get(expression, Boolean.class);
    }

    public boolean getBoolean(String expression, Locale locale) {
        return this.get(expression, locale, Boolean.class);
    }

    public <T> T get(String expression, Class<T> expectedType) {
        return this.get(expression, this.request.getLocale(), expectedType);
    }

    public <T> T get(String expression, Locale locale, Class<T> expectedType) {
        if (expression == null) {
            return null;
        }
        return this.resolver.resolve(expression, locale, expectedType, this.request);
    }

    private static SlingHttpServletRequest toSlingRequest(ServletRequest req) {
        while (!(req instanceof SlingHttpServletRequest)) {
            if (req instanceof ServletRequestWrapper) {
                req = ((ServletRequestWrapper)req).getRequest();
                continue;
            }
            throw new IllegalStateException("request wrong class");
        }
        return (SlingHttpServletRequest)req;
    }
}

