/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;

public class FilteringResourceWrapper
extends ResourceWrapper {
    private ExpressionResolver expressionResolver;
    private SlingHttpServletRequest request;

    public FilteringResourceWrapper(Resource resource, ExpressionResolver expressionResolver, SlingHttpServletRequest request) {
        super(resource);
        this.expressionResolver = expressionResolver;
        this.request = request;
    }

    public Resource getChild(String relPath) {
        Resource child = super.getChild(relPath);
        if (child == null || !this.isVisible(child)) {
            return null;
        }
        return new FilteringResourceWrapper(child, this.expressionResolver, this.request);
    }

    public Iterator<Resource> listChildren() {
        return new TransformIterator((Iterator)new FilterIterator(super.listChildren(), new Predicate(){

            public boolean evaluate(Object o) {
                return FilteringResourceWrapper.this.isVisible((Resource)o);
            }
        }), new Transformer(){

            public Object transform(Object o) {
                return new FilteringResourceWrapper((Resource)o, FilteringResourceWrapper.this.expressionResolver, FilteringResourceWrapper.this.request);
            }
        });
    }

    public Iterable<Resource> getChildren() {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return FilteringResourceWrapper.this.listChildren();
            }
        };
    }

    public boolean hasChildren() {
        if (!super.hasChildren()) {
            return false;
        }
        return this.listChildren().hasNext();
    }

    public String getResourceType() {
        if (this.isResourceType("granite/ui/components/coral/foundation/include")) {
            return "granite/ui/components/coral/foundation/includewrapper";
        }
        return super.getResourceType();
    }

    private boolean isVisible(Resource r) {
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, this.request);
        ValueMap vm = r.getValueMap();
        return !ex.getBoolean((String)vm.get("granite:hide", (Object)"false"));
    }
}

