/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class LayoutBuilder {
    private static final String NAME = "name";
    private JSONObject result;
    private String resourceType;
    private ValueMap vm;

    public static LayoutBuilder from(Config config) {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT));
    }

    public static LayoutBuilder from(Config config, String defaultResourceType) {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT), defaultResourceType);
    }

    public static LayoutBuilder from(Resource resource) {
        return LayoutBuilder.from(resource, null);
    }

    public static LayoutBuilder from(Resource resource, String defaultResourceType) {
        LayoutBuilder b = new LayoutBuilder();
        b.vm = resource != null ? resource.getValueMap() : new ValueMapDecorator(new HashMap());
        b.setResourceType((String)b.vm.get("sling:resourceType", (Object)defaultResourceType));
        return b;
    }

    private void init() {
        if (this.result != null) {
            return;
        }
        this.result = new JSONObject();
        if (this.vm != null) {
            this.add((Map<String, Object>)this.vm);
        }
    }

    public boolean hasName() {
        this.init();
        return this.result.has(NAME);
    }

    public String getName() {
        this.init();
        return this.result.optString(NAME, null);
    }

    public void setName(String name) {
        try {
            this.init();
            this.result.put(NAME, (Object)name);
        }
        catch (JSONException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void add(String key, Object value) {
        try {
            this.init();
            this.result.accumulate(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(Map<String, Object> data) {
        try {
            this.init();
            for (Map.Entry<String, Object> e : data.entrySet()) {
                String key = e.getKey();
                if (key.indexOf(":") >= 0) continue;
                this.result.accumulate(key, e.getValue());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject toJSON() {
        this.init();
        return this.result;
    }
}

