/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.sling.api.SlingHttpServletRequest;

public class State {
    private SlingHttpServletRequest request;
    private Set<String> names;

    public State(SlingHttpServletRequest request) {
        this.request = request;
    }

    public String get(String name) {
        Item i = this.getItem(name);
        return i == null ? null : i.getString();
    }

    public String get(String name, String defaultValue) {
        Item i = this.getItem(name);
        return i == null ? defaultValue : i.getString();
    }

    public boolean get(String name, boolean defaultValue) {
        Item i = this.getItem(name);
        if (i == null || !"true".equals(i.getString()) && !"false".equals(i.getString())) {
            return defaultValue;
        }
        return i.getBoolean();
    }

    public int get(String name, int defaultValue) {
        try {
            Item i = this.getItem(name);
            return i == null ? defaultValue : i.getInt();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Iterator<String> names() {
        if (this.names == null) {
            this.names = new LinkedHashSet<String>();
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (c.isHttpOnly()) continue;
                    this.names.add(c.getName());
                }
            }
        }
        return this.names.iterator();
    }

    public Item getItem(String name) {
        Cookie c = this.request.getCookie(name);
        if (c == null || c.isHttpOnly()) {
            return null;
        }
        try {
            return new ItemImpl(name, URLDecoder.decode(c.getValue(), "utf-8"));
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private class ItemImpl
    implements Item {
        private String name;
        private String value;

        public ItemImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        public boolean getBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        @Override
        public int getInt() throws NumberFormatException {
            return Integer.parseInt(this.value);
        }
    }

    public static interface Item {
        public String getName();

        public String getString();

        public boolean getBoolean();

        public int getInt() throws NumberFormatException;
    }
}

