/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.ds;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;

public class ValueMapResource
extends SyntheticResource {
    private ValueMap vm;
    private Collection<Resource> children;

    public ValueMapResource(ResourceResolver resourceResolver, String path, String resourceType, ValueMap vm) {
        super(resourceResolver, path, resourceType);
        this.vm = vm;
    }

    public ValueMapResource(ResourceResolver resourceResolver, String path, String resourceType, ValueMap vm, Collection<Resource> children) {
        this(resourceResolver, path, resourceType, vm);
        this.children = children;
    }

    public ValueMapResource(ResourceResolver resourceResolver, ResourceMetadata rm, String resourceType, ValueMap vm) {
        super(resourceResolver, rm, resourceType);
        this.vm = vm;
    }

    public ValueMapResource(ResourceResolver resourceResolver, ResourceMetadata rm, String resourceType, ValueMap vm, Collection<Resource> children) {
        this(resourceResolver, rm, resourceType, vm);
        this.children = children;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (ValueMap.class.equals(type)) {
            return (Type)this.vm;
        }
        return (Type)super.adaptTo(type);
    }

    public Resource getChild(String relPath) {
        if (this.children == null) {
            return super.getChild(relPath);
        }
        for (Resource child : this.children) {
            if (child.getPath() == null || !child.getPath().equals(this.getPath() + "/" + relPath)) continue;
            return child;
        }
        return null;
    }

    public Iterator<Resource> listChildren() {
        if (this.children == null) {
            return super.listChildren();
        }
        return this.children.iterator();
    }

    public Iterable<Resource> getChildren() {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return ValueMapResource.this.listChildren();
            }
        };
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return super.hasChildren();
        }
        return !this.children.isEmpty();
    }
}

