/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.formbuilder.impl;

import com.adobe.granite.ui.components.formbuilder.FormResourceManager;
import com.adobe.granite.ui.components.formbuilder.impl.FormResourceImpl;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.ValueMapDecorator;

@Component(metatype=false)
@Service
public class FormResourceManagerImpl
implements FormResourceManager {
    private static final String listOrderKey = "listOrder";
    private static final String fieldTemplateID = "{{field_id}}";
    private static final String optionTemplateID = "{{option_id}}";
    private static final String optionValueTemplateID = "{{value}}";

    @Override
    public Resource getFormFieldResource(Resource formResource) {
        return this.getFormFieldResource(formResource, "Field Label");
    }

    @Override
    public Resource getFormFieldResource(Resource formResource, String label) {
        FormResourceImpl fieldResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        HashMap<String, Object> v = new HashMap<String, Object>();
        v.put("id", "Key-{{field_id}}");
        v.put("fieldLabel", label);
        v.put("value", "");
        v.put("emptyText", "");
        v.put("min", "0");
        v.put("max", "255");
        v.put("minlength", "0");
        v.put("maxlength", "255");
        v.put("instructions", "");
        v.put("required", false);
        fieldResource.fieldValueMap = new ValueMapDecorator(v);
        return fieldResource;
    }

    @Override
    public Resource getFormDropdownResource(Resource formResource) {
        FormResourceImpl fieldResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        HashMap<String, Object> v = new HashMap<String, Object>();
        v.put("id", "Key-{{field_id}}");
        v.put("fieldLabel", "Dropdown Field");
        v.put("text", "Select");
        v.put("value", "");
        v.put("emptyText", "");
        v.put("instructions", "");
        v.put("required", false);
        fieldResource.fieldValueMap = new ValueMapDecorator(v);
        return fieldResource;
    }

    @Override
    public Resource getDropdownOptionResource(Resource dropdownResource) {
        FormResourceImpl optionResource = new FormResourceImpl(dropdownResource.getResourceResolver(), dropdownResource.getPath() + "/items/" + optionTemplateID, "");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("text", optionValueTemplateID);
        values.put("value", optionValueTemplateID);
        optionResource.fieldValueMap = new ValueMapDecorator(values);
        return optionResource;
    }

    @Override
    public Resource getCheckboxFieldResource(Resource formResource) {
        return this.getCheckboxFieldResource(formResource, "Field Text");
    }

    @Override
    public Resource getCheckboxFieldResource(Resource formResource, String label) {
        FormResourceImpl checkboxResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        HashMap<String, String> v = new HashMap<String, String>();
        v.put("sling.resolutionPath", "Field Label");
        v.put("id", "Key-{{field_id}}");
        v.put("fieldLabel", "Field Label");
        v.put("text", label);
        v.put("instructions", "");
        checkboxResource.fieldValueMap = new ValueMapDecorator(v);
        return checkboxResource;
    }

    @Override
    public Resource getDateFieldResource(Resource formResource) {
        FormResourceImpl datefieldReource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        HashMap<String, String> v = new HashMap<String, String>();
        v.put("fieldLabel", "Date Field");
        v.put("id", "Key-{{field_id}}");
        v.put("name", "./jcr:content/onTime");
        v.put("sling:resourceType", "granite/ui/components/foundation/form/datepicker");
        v.put("jcr:primaryType", "nt:unstructured");
        datefieldReource.fieldValueMap = new ValueMapDecorator(v);
        return datefieldReource;
    }

    @Override
    public Resource getDefaultDateResource(Resource formResource) {
        return this.getDefaultDateResource(formResource, "Default Value");
    }

    @Override
    public Resource getDefaultDateResource(Resource formResource, String label) {
        FormResourceImpl datefieldResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        String key = formResource.getName();
        HashMap<String, String> v = new HashMap<String, String>();
        v.put("sling.resolutionPath", "Field Label");
        v.put("fieldLabel", label);
        v.put("value", "");
        v.put("name", "./items/" + key + "/value");
        datefieldResource.fieldValueMap = new ValueMapDecorator(v);
        return datefieldResource;
    }

    @Override
    public Resource getDefaultPropertyFieldResource(Resource formResource, HashMap<String, Object> values) {
        FormResourceImpl datefieldResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        datefieldResource.fieldValueMap = new ValueMapDecorator(values);
        return datefieldResource;
    }

    @Override
    public Resource getHiddenFieldResource(Resource formResource) {
        FormResourceImpl fieldResource = new FormResourceImpl(formResource.getResourceResolver(), formResource.getPath() + "/items/" + fieldTemplateID, "");
        HashMap<String, String> v = new HashMap<String, String>();
        v.put("sling.resolutionPath", "Field Label");
        v.put("id", "Key-{{field_id}}");
        v.put("fieldLabel", "Hidden");
        v.put("value", "");
        fieldResource.fieldValueMap = new ValueMapDecorator(v);
        return fieldResource;
    }

    @Override
    public String getFieldTemplateID() {
        return fieldTemplateID;
    }

    @Override
    public String getOptionTemplateID() {
        return optionTemplateID;
    }

    @Override
    public String getOrderKey() {
        return listOrderKey;
    }
}

