/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.impl;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.Options;
import com.adobe.granite.ui.components.State;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.ResourceDataSource;
import com.adobe.granite.ui.components.impl.OptionsHolder;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;

public final class BaseComponentHelper {
    private static final String ATTRIBUTE_CACHE_RC = BaseComponentHelper.class.getName() + ".cache.rc";
    protected SlingScriptHelper sling;
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    private I18n i18n;
    private XSSAPI xss;
    private Config config;
    private Value value;
    private ExpressionHelper ex;
    private State state;
    private OptionsHolder optionsHolder;

    public BaseComponentHelper(SlingScriptHelper sling, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.sling = sling;
        this.request = request;
        this.response = response;
        this.optionsHolder = (OptionsHolder)request.getAttribute(OptionsHolder.class.getName());
        request.removeAttribute(OptionsHolder.class.getName());
    }

    public SlingScriptHelper getSling() {
        return this.sling;
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public SlingHttpServletResponse getResponse() {
        return this.response;
    }

    public I18n getI18n() {
        if (this.i18n == null) {
            this.i18n = new I18n((HttpServletRequest)this.request);
        }
        return this.i18n;
    }

    public XSSAPI getXss() {
        if (this.xss == null) {
            this.xss = ((XSSAPI)this.sling.getService(XSSAPI.class)).getRequestSpecificAPI(this.request);
        }
        return this.xss;
    }

    public Config getConfig() {
        if (this.config == null) {
            this.config = new Config(this.request.getResource());
        }
        return this.config;
    }

    public Value getValue() {
        if (this.value == null) {
            this.value = new Value(this.request, this.getConfig());
        }
        return this.value;
    }

    public ExpressionHelper getExpressionHelper() {
        if (this.ex == null) {
            this.ex = new ExpressionHelper((ExpressionResolver)this.sling.getService(ExpressionResolver.class), this.request);
        }
        return this.ex;
    }

    public State getState() {
        if (this.state == null) {
            this.state = new State(this.request);
        }
        return this.state;
    }

    public Tag consumeTag() {
        Tag tag = this.getOptions().tag();
        return tag == null ? new Tag(new AttrBuilder((HttpServletRequest)this.request, this.getXss())) : tag;
    }

    public void populateCommonAttrs(AttrBuilder attrs) {
        this.populateCommonAttrs(attrs, this.getRequest().getResource());
    }

    public void populateCommonAttrs(AttrBuilder attrs, Resource src) {
        I18n i18n = this.getI18n();
        Config config = new Config(src);
        ExpressionHelper ex = this.getExpressionHelper();
        attrs.add("id", ex.getString(config.get("granite:id", String.class)));
        attrs.addRel(ex.getString(config.get("granite:rel", String.class)));
        attrs.addClass(ex.getString(config.get("granite:class", String.class)));
        attrs.add("title", i18n.getVar(config.get("granite:title", String.class)));
        attrs.addBoolean("hidden", config.get("granite:hidden", false));
        attrs.addBoolean("itemscope", config.get("granite:itemscope", false));
        attrs.add("itemtype", config.get("granite:itemtype", String.class));
        attrs.add("itemprop", config.get("granite:itemprop", String.class));
        Resource data = src.getChild("granite:data");
        if (data == null) {
            return;
        }
        for (Map.Entry e : data.getValueMap().entrySet()) {
            String key = (String)e.getKey();
            if (key.indexOf(":") >= 0) continue;
            Object v = e.getValue();
            if (v instanceof String) {
                v = ex.getString(v.toString());
            }
            attrs.addOther(key, v.toString());
        }
    }

    public Options getOptions() {
        if (this.optionsHolder != null && this.optionsHolder.getPath().equals(this.request.getResource().getPath()) && this.optionsHolder.getOptions() != null) {
            return this.optionsHolder.getOptions();
        }
        return new Options();
    }

    public String getReadOnlyResourceType() {
        return this.getReadOnlyResourceType(this.getRequest().getResource());
    }

    public String getReadOnlyResourceType(Resource resource) {
        String resourceType = BaseComponentHelper.getResourceType(resource);
        if (resourceType == null) {
            return null;
        }
        Resource r = this.getRequest().getResourceResolver().getResource(resourceType);
        if (r == null) {
            return null;
        }
        String path = new Config(r).get("granite:readOnlyResourceType", String.class);
        if (path != null) {
            return path;
        }
        Resource ro = r.getChild("readonly");
        if (ro != null) {
            return ro.getPath();
        }
        return null;
    }

    public DataSource getItemDataSource() throws ServletException, IOException {
        return this.getItemDataSource(this.getRequest().getResource());
    }

    public DataSource getItemDataSource(Resource resource) throws ServletException, IOException {
        Resource items = resource.getChild(Config.ITEMS);
        if (items != null) {
            return new ResourceDataSource(items);
        }
        Resource datasource = resource.getChild(Config.DATASOURCE);
        if (datasource != null) {
            return this.asDataSource(datasource, resource);
        }
        return EmptyDataSource.instance();
    }

    public DataSource asDataSource(Resource datasource) throws ServletException, IOException {
        return this.asDataSource(datasource, null);
    }

    public DataSource asDataSource(Resource datasource, Resource context) throws ServletException, IOException {
        DataSource ds;
        if (datasource == null) {
            return null;
        }
        if (context == null) {
            context = datasource;
        }
        return (ds = this.fetchData(context, BaseComponentHelper.getResourceType(datasource), DataSource.class)) != null ? ds : EmptyDataSource.instance();
    }

    public RenderCondition getRenderCondition() throws ServletException, IOException {
        return this.getRenderCondition(this.getRequest().getResource());
    }

    public RenderCondition getRenderCondition(Resource resource) throws ServletException, IOException {
        RenderCondition rc = null;
        Resource condition = resource.getChild("granite:rendercondition");
        if (condition == null) {
            condition = resource.getChild(Config.RENDERCONDITION);
        }
        if (condition != null) {
            String resourceType = BaseComponentHelper.getResourceType(condition, "granite/ui/components/foundation/renderconditions/simple");
            rc = this.fetchData(condition, resourceType, RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        return rc;
    }

    public RenderCondition getRenderCondition(Resource resource, boolean cache) throws ServletException, IOException {
        String key;
        Map<String, RenderCondition> cacheMap = this.getRenderConditionCache();
        RenderCondition rc = cacheMap.get(key = resource.getPath());
        if (rc != null) {
            return rc;
        }
        Resource condition = resource.getChild("granite:rendercondition");
        if (condition != null) {
            rc = this.fetchData(condition, BaseComponentHelper.getResourceType(condition), RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        if (cache) {
            cacheMap.put(key, rc);
        }
        return rc;
    }

    private Map<String, RenderCondition> getRenderConditionCache() {
        SlingHttpServletRequest request = this.getRequest();
        HashMap cache = (HashMap)request.getAttribute(ATTRIBUTE_CACHE_RC);
        if (cache == null) {
            cache = new HashMap();
            request.setAttribute(ATTRIBUTE_CACHE_RC, cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetchData(Resource resource, String resourceType, Class<T> type) throws ServletException, IOException {
        if (resourceType == null) {
            return null;
        }
        SlingHttpServletRequest request = this.getRequest();
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)request, (ServletResponse)this.response);
                Object object = request.getAttribute(type.getName());
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            request.removeAttribute(type.getName());
        }
    }

    private static String getResourceType(Resource resource) {
        return new Config(resource).get("sling:resourceType", String.class);
    }

    private static String getResourceType(Resource resource, String defaultValue) {
        return new Config(resource).get("sling:resourceType", defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Resource resource, String resourceType, String selectors, Options options) throws ServletException, IOException {
        SlingHttpServletRequest request = this.getRequest();
        try {
            RequestDispatcher dispatcher;
            OptionsHolder holder = new OptionsHolder(options, resource.getPath());
            request.setAttribute(OptionsHolder.class.getName(), (Object)holder);
            RequestDispatcherOptions dispatcherOptions = new RequestDispatcherOptions(resourceType);
            if (selectors != null && selectors.length() > 0) {
                dispatcherOptions.setReplaceSelectors(selectors);
            }
            if ((dispatcher = request.getRequestDispatcher(resource, dispatcherOptions)) != null) {
                dispatcher.include((ServletRequest)request, (ServletResponse)this.getResponse());
            }
        }
        finally {
            request.removeAttribute(OptionsHolder.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String script, Options options) throws ServletException, IOException {
        SlingHttpServletRequest request = this.getRequest();
        SlingScriptHelper sling = this.getSling();
        try {
            OptionsHolder holder = new OptionsHolder(options, request.getResource().getPath());
            request.setAttribute(OptionsHolder.class.getName(), (Object)holder);
            ServletResolver servletResolver = (ServletResolver)sling.getService(ServletResolver.class);
            Servlet servlet = servletResolver.resolveServlet(request.getResource(), script);
            if (servlet == null) {
                throw new ServletException("Could not find script " + script);
            }
            servlet.service((ServletRequest)request, (ServletResponse)this.getResponse());
        }
        finally {
            request.removeAttribute(OptionsHolder.class.getName());
        }
    }
}

