/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.impl;

import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.impl.CustomVariableELResolver;
import com.adobe.granite.ui.components.impl.ExternalImplicitObjectELResolver;
import com.adobe.granite.ui.components.impl.GraniteFunctions;
import com.adobe.granite.ui.components.impl.NullVariableMapper;
import com.adobe.granite.ui.components.impl.QueryStringELResolver;
import com.adobe.granite.ui.components.impl.RequestPathInfoELResolver;
import com.adobe.granite.ui.components.impl.StateELResolver;
import com.adobe.granite.ui.components.impl.TenantELResolver;
import java.util.Locale;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.jsp.PageContext;
import org.apache.el.ExpressionFactoryImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.scripting.jsp.jasper.runtime.ProtectedFunctionMapper;

@Component(metatype=false, immediate=true)
@Service(value={ExpressionResolver.class})
public class ExpressionResolverImpl
implements ExpressionResolver {
    private static final String EX_FACTORY_NAME = ExpressionResolverImpl.class.getName() + ".exfactory";
    private static final String EL_CONTEXT_NAME = ExpressionResolverImpl.class.getName() + ".elcontext";
    private static final VariableMapper VARIABLE_MAPPER = new NullVariableMapper();
    private static final ELResolver EL_RESOLVER;
    private static final FunctionMapper FUNCTION_MAPPER;

    @Override
    public <T> T resolve(String expression, Locale locale, Class<T> expectedType, PageContext pageContext) {
        SlingHttpServletRequest req = ExpressionResolverImpl.toSlingRequest(pageContext.getRequest());
        return this.resolve(expression, locale, expectedType, req);
    }

    @Override
    public <T> T resolve(String expression, Locale locale, Class<T> expectedType, SlingHttpServletRequest req) {
        ExpressionFactory expressionFactory = this.getExpressionFactory((ServletRequest)req);
        ELContext ctx = this.getELContext(req);
        ctx.setLocale(locale);
        GraniteFunctions.setRequest(req);
        ValueExpression e = expressionFactory.createValueExpression(ctx, expression, expectedType);
        return (T)e.getValue(ctx);
    }

    private ExpressionFactory getExpressionFactory(ServletRequest request) {
        ExpressionFactory factory = (ExpressionFactory)request.getAttribute(EX_FACTORY_NAME);
        if (factory == null) {
            factory = new ExpressionFactoryImpl();
            request.setAttribute(EX_FACTORY_NAME, (Object)factory);
        }
        return factory;
    }

    private ELContext getELContext(SlingHttpServletRequest request) {
        ELContext ctx = (ELContext)request.getAttribute(EL_CONTEXT_NAME);
        if (ctx == null) {
            ctx = this.createElContext();
            ctx.putContext(SlingHttpServletRequest.class, (Object)request);
            request.setAttribute(EL_CONTEXT_NAME, (Object)ctx);
        }
        return ctx;
    }

    private ELContext createElContext() {
        return new ELContext(){

            public ELResolver getELResolver() {
                return EL_RESOLVER;
            }

            public FunctionMapper getFunctionMapper() {
                return FUNCTION_MAPPER;
            }

            public VariableMapper getVariableMapper() {
                return VARIABLE_MAPPER;
            }
        };
    }

    private static SlingHttpServletRequest toSlingRequest(ServletRequest req) {
        while (!(req instanceof SlingHttpServletRequest)) {
            if (req instanceof ServletRequestWrapper) {
                req = ((ServletRequestWrapper)req).getRequest();
                continue;
            }
            throw new IllegalStateException("request wrong class");
        }
        return (SlingHttpServletRequest)req;
    }

    static {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new MapELResolver(true));
        resolver.add((ELResolver)new ListELResolver(true));
        resolver.add((ELResolver)new ArrayELResolver(true));
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new ExternalImplicitObjectELResolver());
        resolver.add((ELResolver)new QueryStringELResolver());
        resolver.add((ELResolver)new RequestPathInfoELResolver());
        resolver.add((ELResolver)new StateELResolver());
        resolver.add((ELResolver)new TenantELResolver());
        resolver.add((ELResolver)new CustomVariableELResolver());
        resolver.add((ELResolver)new BeanELResolver(true));
        EL_RESOLVER = resolver;
        ProtectedFunctionMapper mapper = ProtectedFunctionMapper.getInstance();
        mapper.mapFunction("granite:encodeURIComponent", Text.class, "escape", new Class[]{String.class});
        mapper.mapFunction("granite:encodeURIPath", Text.class, "escapePath", new Class[]{String.class});
        mapper.mapFunction("granite:uritemplate", GraniteFunctions.class, "uritemplate", new Class[]{String.class});
        mapper.mapFunction("granite:absUritemplate", GraniteFunctions.class, "uritemplate", new Class[]{String.class, Boolean.TYPE});
        mapper.mapFunction("granite:url", GraniteFunctions.class, "url", new Class[]{String.class});
        mapper.mapFunction("granite:toJSONArray", GraniteFunctions.class, "toJSONArray", new Class[]{String[].class});
        mapper.mapFunction("granite:toQueryString", GraniteFunctions.class, "toQueryString", new Class[]{String.class, String[].class});
        mapper.mapFunction("granite:concat", GraniteFunctions.class, "concat", new Class[]{Object.class, Object.class});
        mapper.mapFunction("granite:relativeParent", GraniteFunctions.class, "getRelativeParent", new Class[]{String.class, Integer.TYPE});
        mapper.mapFunction("granite:contains", GraniteFunctions.class, "contains", new Class[]{String.class, String.class});
        mapper.mapFunction("granite:containsIgnoreCase", GraniteFunctions.class, "containsIgnoreCase", new Class[]{String.class, String.class});
        FUNCTION_MAPPER = mapper;
    }
}

