/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.impl;

import java.beans.FeatureDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.servlet.http.Cookie;
import org.apache.sling.api.SlingHttpServletRequest;

public class ExternalImplicitObjectELResolver
extends ELResolver {
    private static final String[] PROPERTY_NAMES = new String[]{"param", "paramValues", "header", "headerValues", "cookie"};
    private static final List<String> HEADER_BLACKLIST = Arrays.asList("authorization", "cookie", "proxy-authorization", "host", "x-forwarded-for", "x-forwarded-host");

    private static boolean isValid(Object base, Object property) {
        if (base != null) {
            return false;
        }
        for (String name : PROPERTY_NAMES) {
            if (!name.equals(property)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null) {
            return null;
        }
        if ("param".equals(property)) {
            final SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return new ScopeMap<String>(){

                @Override
                protected Enumeration<String> getAttributeNames() {
                    return req.getParameterNames();
                }

                @Override
                protected String getAttribute(String name) {
                    return req.getParameter(name);
                }
            };
        }
        if ("paramValues".equals(property)) {
            final SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return new ScopeMap<String[]>(){

                @Override
                protected Enumeration<String> getAttributeNames() {
                    return req.getParameterNames();
                }

                @Override
                protected String[] getAttribute(String name) {
                    return req.getParameterValues(name);
                }
            };
        }
        if ("header".equals(property)) {
            final SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return new ScopeMap<String>(HEADER_BLACKLIST){

                @Override
                protected Enumeration<String> getAttributeNames() {
                    return req.getHeaderNames();
                }

                @Override
                protected String getAttribute(String name) {
                    return req.getHeader(name);
                }
            };
        }
        if ("headerValues".equals(property)) {
            final SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return new ScopeMap<String[]>(HEADER_BLACKLIST){

                @Override
                protected Enumeration<String> getAttributeNames() {
                    return req.getHeaderNames();
                }

                @Override
                protected String[] getAttribute(String name) {
                    Enumeration values = req.getHeaders(name);
                    if (values == null) {
                        return null;
                    }
                    return Collections.list(values).toArray(new String[0]);
                }
            };
        }
        if ("cookie".equals(property)) {
            final SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return new ScopeMap<Cookie>(){

                @Override
                protected Enumeration<String> getAttributeNames() {
                    Cookie[] cookies = req.getCookies();
                    if (cookies != null) {
                        Vector<String> v = new Vector<String>();
                        for (Cookie c : cookies) {
                            if (c.isHttpOnly()) continue;
                            v.add(c.getName());
                        }
                        return v.elements();
                    }
                    return null;
                }

                @Override
                protected Cookie getAttribute(String name) {
                    Cookie[] cookies = req.getCookies();
                    if (cookies != null) {
                        for (Cookie c : cookies) {
                            if (c.isHttpOnly() || !name.equals(c.getName())) continue;
                            return c;
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (ExternalImplicitObjectELResolver.isValid(base, property)) {
            context.setPropertyResolved(true);
            return Map.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (ExternalImplicitObjectELResolver.isValid(base, property)) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (ExternalImplicitObjectELResolver.isValid(base, property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(5);
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setName("param");
        descriptor.setDisplayName("param");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("paramValues");
        descriptor.setDisplayName("paramValues");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("header");
        descriptor.setDisplayName("header");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("headerValues");
        descriptor.setDisplayName("headerValues");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        descriptor = new FeatureDescriptor();
        descriptor.setName("cookie");
        descriptor.setDisplayName("cookie");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", Map.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    private abstract class ScopeMap<V>
    extends AbstractMap<String, V> {
        private List<String> blacklist = null;

        public ScopeMap() {
        }

        public ScopeMap(List<String> blacklist) {
            this.blacklist = blacklist;
        }

        protected abstract Enumeration<String> getAttributeNames();

        protected abstract V getAttribute(String var1);

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            Enumeration<String> e = this.getAttributeNames();
            HashSet<Map.Entry<String, V>> set = new HashSet<Map.Entry<String, V>>();
            if (e != null) {
                while (e.hasMoreElements()) {
                    String name = e.nextElement();
                    if (this.blacklist != null && this.blacklist.contains(name.toLowerCase())) continue;
                    set.add(new ScopeEntry(name));
                }
            }
            return set;
        }

        private class ScopeEntry
        implements Map.Entry<String, V> {
            private final String key;

            public ScopeEntry(String key) {
                this.key = key;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return ScopeMap.this.getAttribute(this.key);
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

