/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.impl;

import com.adobe.granite.ui.components.State;
import java.beans.FeatureDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.apache.sling.api.SlingHttpServletRequest;

public class StateELResolver
extends ELResolver {
    private static final String PROPERTY_NAME = "state";

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return null;
        }
        if (PROPERTY_NAME.equals(property)) {
            SlingHttpServletRequest req = (SlingHttpServletRequest)context.getContext(SlingHttpServletRequest.class);
            context.setPropertyResolved(true);
            return this.getState(req);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && PROPERTY_NAME.equals(property)) {
            context.setPropertyResolved(true);
            return StateMap.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && PROPERTY_NAME.equals(property)) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && PROPERTY_NAME.equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(1);
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setName(PROPERTY_NAME);
        descriptor.setDisplayName(PROPERTY_NAME);
        descriptor.setShortDescription("A variable exposing the client state of current request");
        descriptor.setExpert(false);
        descriptor.setHidden(false);
        descriptor.setPreferred(true);
        descriptor.setValue("type", StateMap.class);
        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor);
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    private StateMap getState(SlingHttpServletRequest request) {
        String key = StateELResolver.class.getName();
        StateMap map = (StateMap)request.getAttribute(key);
        if (map == null) {
            map = new StateMap(new State(request));
            request.setAttribute(key, (Object)map);
        }
        return map;
    }

    private class StateMap
    extends AbstractMap<String, State.Item> {
        private State state;

        public StateMap(State state) {
            this.state = state;
        }

        @Override
        public Set<Map.Entry<String, State.Item>> entrySet() {
            HashSet<Map.Entry<String, State.Item>> set = new HashSet<Map.Entry<String, State.Item>>();
            Iterator<String> it = this.state.names();
            while (it.hasNext()) {
                set.add(new StateMapEntry(this.state.getItem(it.next())));
            }
            return set;
        }

        private class StateMapEntry
        implements Map.Entry<String, State.Item> {
            private State.Item item;

            public StateMapEntry(State.Item item) {
                this.item = item;
            }

            @Override
            public String getKey() {
                return this.item.getName();
            }

            @Override
            public State.Item getValue() {
                return this.item;
            }

            @Override
            public State.Item setValue(State.Item value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                return obj != null && this.hashCode() == obj.hashCode();
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode();
            }
        }
    }
}

