/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.rendercondition;

import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;

public class PrivilegeRenderCondition
implements RenderCondition {
    private AccessControlManager acm;
    private String path;
    private Privilege[] privileges;

    public PrivilegeRenderCondition(AccessControlManager acm, String path, String[] privilegeNames) throws RepositoryException {
        this.acm = acm;
        this.path = path;
        this.privileges = this.converts(privilegeNames);
    }

    public PrivilegeRenderCondition(AccessControlManager acm, String path, Privilege[] privileges) {
        this.acm = acm;
        this.path = path;
        this.privileges = privileges;
    }

    private Privilege[] converts(String[] privilegeNames) throws RepositoryException {
        Privilege[] privileges = new Privilege[privilegeNames.length];
        for (int i = 0; i < privilegeNames.length; ++i) {
            privileges[i] = this.acm.privilegeFromName(privilegeNames[i]);
        }
        return privileges;
    }

    @Override
    public boolean check() throws ServletException {
        try {
            return this.acm.hasPrivileges(this.path, this.privileges);
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

