/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.job;

import com.adobe.granite.workflow.exec.WorkItem;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TimeoutJob.class);
    private static final long serialVersionUID = 5670996916430565635L;
    public static final String TIMEOUT_JOB_TOPIC = "com/adobe/granite/workflow/timeout/job";
    public static final String TIMEOUT_JOB = "com.adobe.granite.workflow.console.timeout.job";
    protected String itemId;
    String handler;
    protected long timeStarted = 0L;

    public TimeoutJob(WorkItem item, String handler) {
        if (item == null || handler == null) {
            throw new IllegalArgumentException("item or handler must not be null.");
        }
        this.itemId = item.getId();
        this.timeStarted = item.getTimeStarted().getTime();
        this.handler = handler;
    }

    public String getWorkItemId() {
        return this.itemId;
    }

    public String getHandler() {
        return this.handler;
    }

    public Event createEvent(boolean executeParallel, long seconds, boolean addOffset) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(TIMEOUT_JOB, this);
        ((Dictionary)props).put("event.job.parallel", executeParallel);
        ((Dictionary)props).put("event.topic.timed", "org/apache/sling/event/job");
        ((Dictionary)props).put("event.job.topic", TIMEOUT_JOB_TOPIC);
        ((Dictionary)props).put("event.job.id", this.itemId + "_" + this.timeStarted);
        Date date = this.calculateDate(seconds, addOffset);
        ((Dictionary)props).put("event.timed.date", date);
        log.debug("create timeout event {} ", props);
        return new Event("org/apache/sling/event/timed", props);
    }

    public Event cancelEvent(boolean executeParallel) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(TIMEOUT_JOB, this);
        ((Dictionary)props).put("event.job.parallel", executeParallel);
        ((Dictionary)props).put("event.topic.timed", "org/apache/sling/event/job");
        ((Dictionary)props).put("event.job.topic", TIMEOUT_JOB_TOPIC);
        ((Dictionary)props).put("event.job.id", this.itemId + "_" + this.timeStarted);
        log.debug("create timeout cancel event {}", props);
        return new Event("org/apache/sling/event/timed", props);
    }

    private Date calculateDate(long seconds, boolean addOffset) {
        Calendar cal = Calendar.getInstance();
        long millies = seconds * 1000L;
        if (addOffset) {
            millies += cal.getTimeInMillis();
        }
        cal.setTimeInMillis(millies);
        return cal.getTime();
    }
}

