/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.job;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;

public class WorkflowJob
implements Serializable {
    private static final long serialVersionUID = 5670996916430565635L;
    public static final String JOB_TOPIC = "com/adobe/granite/workflow/job";
    public static final String JOB_TOPIC_WC = "com/adobe/granite/workflow/job/*";
    public static final String WORKFLOW_JOB = "com.adobe.granite.workflow.job";
    public static final String WORKFLOW_JOB_ID = "com.adobe.granite.workflow.jobid";
    protected Map item;

    public WorkflowJob(Map item) {
        if (item == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        this.item = item;
    }

    public Map getWorkItemMap() {
        return this.item;
    }

    public Event createJobEvent(Integer retryCount, int numOfParallelProcs, String jobId) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(WORKFLOW_JOB, this);
        ((Dictionary)props).put("event.job.retries", retryCount);
        if (this.item.get("workflowModelId") != null) {
            String workflowModelId = (String)this.item.get("workflowModelId");
            workflowModelId = workflowModelId.replace(":", "_");
            ((Dictionary)props).put("event.job.topic", JOB_TOPIC + workflowModelId);
        } else {
            ((Dictionary)props).put("event.job.topic", JOB_TOPIC);
        }
        ((Dictionary)props).put(WORKFLOW_JOB_ID, jobId);
        return new Event("org/apache/sling/event/job", props);
    }
}

