/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.exec.WorkflowProcess;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"workflow/console"}), @Property(name="sling.servlet.selectors", value={"processes"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class ConsoleServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private ComponentContext context;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors != null && selectors.length == 1 && selectors[0].equals("processes") && request.getRequestPathInfo().getExtension().equals("json")) {
            try {
                ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(WorkflowProcess.class.getName(), null);
                writer.object();
                if (refs != null) {
                    for (ServiceReference serviceReference : refs) {
                        String className = this.getProcessClassName(serviceReference);
                        if (className == null) continue;
                        writer.key("option");
                        writer.object();
                        writer.key("value").value((Object)className);
                        writer.key("text").value((Object)className);
                        writer.endObject();
                    }
                }
                writer.endObject();
            }
            catch (InvalidSyntaxException e) {
                throw new ServletException("Could not lookup java processes.", (Throwable)e);
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String getProcessClassName(ServiceReference serviceReference) {
        String processClassName = null;
        Object process = this.context.getBundleContext().getService(serviceReference);
        if (process != null) {
            processClassName = process.getClass().getName();
        }
        return processClassName;
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }
}

