/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.console.servlet.ServletBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Workflow Engine POST Servlet", description="Handles POST requests to the workflow engine resource")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/engine"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class EngineServlet
extends ServletBase {
    private static final long serialVersionUID = 6204110984704999595L;
    @Reference(policy=ReferencePolicy.STATIC)
    private ScrService scrService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameterMap params = request.getRequestParameterMap();
        RequestParameter reqPara = null;
        reqPara = params.getValue("state");
        if (reqPara != null) {
            String state = reqPara.getString();
            for (org.apache.felix.scr.Component comp : this.scrService.getComponents()) {
                if (!this.isWorkflowService(comp)) continue;
                if (state.equals("ACTIVE") && comp.getState() == 1) {
                    comp.enable();
                    this.sendResponse((HttpServletResponse)response, 200, "Service enabled");
                    continue;
                }
                if (state.equals("DISABLED") && comp.getState() == 16) {
                    comp.disable();
                    this.sendResponse((HttpServletResponse)response, 200, "Service disabled");
                    continue;
                }
                if (state.equals("ACTIVE") && comp.getState() == 16) {
                    response.setStatus(409);
                    this.sendResponse((HttpServletResponse)response, 409, "Service cannot be activated");
                    continue;
                }
                if (!state.equals("DISABLED") || comp.getState() != 1) continue;
                this.sendResponse((HttpServletResponse)response, 409, "Service cannot be disabled");
            }
        } else {
            this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
        }
    }

    private boolean isWorkflowService(org.apache.felix.scr.Component comp) {
        return comp.getServices() != null && Arrays.asList(comp.getServices()).contains("com.adobe.granite.workflow.core.WorkflowSessionFactory");
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    protected void bindScrService(ScrService scrService) {
        this.scrService = scrService;
    }

    protected void unbindScrService(ScrService scrService) {
        if (this.scrService == scrService) {
            this.scrService = null;
        }
    }
}

