/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.servlet.WorkflowConsoleUtil;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/workflow/failures"}), @Property(name="sling.servlet.methods", value={"POST", ""}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class FailureCommandServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 2171661388034822790L;
    private static final String COMMAND_TERMINATE_RESTART = "TerminateAndRestart";
    private static final String COMMAND_RETRY_ITEM = "RetryItem";
    private static final String COMMANDPARAM_NAME = "command";
    private static final String PROPERTY_IDS = "IDs";
    private static final String METANAME_CURRENTJOBS = "currentJobs";
    private static final Set<String> METADATA_IGNORE_MAP = new HashSet<String>();

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block12: {
            RequestParameterMap params = request.getRequestParameterMap();
            WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
            RequestParameter command = params.getValue(COMMANDPARAM_NAME);
            if (command != null) {
                try {
                    String jsonPayload = FailureCommandServlet.readJSON(request);
                    JSONObject parameterObject = new JSONObject(jsonPayload);
                    String commandValue = command.getString();
                    if (COMMAND_TERMINATE_RESTART.equals(commandValue)) {
                        JSONArray arrayOfWorkflows = parameterObject.getJSONArray(PROPERTY_IDS);
                        for (int index = 0; index < arrayOfWorkflows.length(); ++index) {
                            if (!(arrayOfWorkflows.get(index) instanceof String)) continue;
                            String worklowId = (String)arrayOfWorkflows.get(index);
                            try {
                                Workflow workflow = wfSession.getWorkflow(worklowId);
                                WorkflowData oldWorkflowData = workflow.getWorkflowData();
                                WorkflowModel model = workflow.getWorkflowModel();
                                String modelId = model.getId();
                                WorkflowModel latestModel = wfSession.getModel(modelId);
                                this.updateMetaData(params, workflow);
                                wfSession.terminateWorkflow(workflow);
                                WorkflowData newWorkflowData = wfSession.newWorkflowData(oldWorkflowData.getPayloadType(), oldWorkflowData.getPayload());
                                this.copyMetaData(oldWorkflowData, newWorkflowData);
                                Workflow newWorkflowInstance = wfSession.startWorkflow(latestModel, newWorkflowData);
                                response.getWriter().write("Restarted " + worklowId + ", new Workflow ID: " + newWorkflowInstance.getId() + "\n");
                                continue;
                            }
                            catch (WorkflowException e) {
                                response.getWriter().write("Failed to restart workflow " + worklowId + "\n");
                                continue;
                            }
                            catch (IOException e) {
                                response.getWriter().write("Failed to restart workflow " + worklowId + "\n");
                            }
                        }
                        break block12;
                    }
                    if (COMMAND_RETRY_ITEM.equals(commandValue)) {
                        JSONArray arrayOfItems = parameterObject.getJSONArray(PROPERTY_IDS);
                        for (int index = 0; index < arrayOfItems.length(); ++index) {
                            if (!(arrayOfItems.get(index) instanceof String)) continue;
                            String itemId = (String)arrayOfItems.get(index);
                            WorkItem item = wfSession.getWorkItem(itemId);
                            WorkflowConsoleUtil.retryStep(wfSession, item);
                        }
                        break block12;
                    }
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid command");
                }
                catch (IllegalStateException e) {
                    this.sendResponse((HttpServletResponse)response, 409, e.getMessage());
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
            }
        }
    }

    private void copyMetaData(WorkflowData oldData, WorkflowData newWorkflowData) {
        Set oldKeySet = oldData.getMetaDataMap().keySet();
        for (String key : oldKeySet) {
            if (METADATA_IGNORE_MAP.contains(key)) continue;
            newWorkflowData.getMetaDataMap().put((Object)key, oldData.getMetaDataMap().get((Object)key));
        }
    }

    public static String readJSON(SlingHttpServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        return FailureCommandServlet.readJSON(reader);
    }

    public static String readJSON(BufferedReader reader) throws IOException {
        String json = "";
        String line = reader.readLine();
        while (line != null) {
            json = json + line;
            line = reader.readLine();
        }
        return json;
    }

    protected void sendResponse(HttpServletResponse response, int status, String message) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(status, message);
        htmlResponse.setTitle(message);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private void updateMetaData(RequestParameterMap params, Workflow workflow) {
        for (String key : params.keySet()) {
            if (key.equals(COMMANDPARAM_NAME) || key.startsWith(":") || key.startsWith("./")) continue;
            RequestParameter para = params.getValue(key);
            workflow.getMetaDataMap().put((Object)key, (Object)para.getString());
            workflow.getWorkflowData().getMetaDataMap().put((Object)key, (Object)para.getString());
        }
    }

    static {
        METADATA_IGNORE_MAP.add(METANAME_CURRENTJOBS);
    }
}

