/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.collection.util.ResultSet;
import com.adobe.granite.workflow.console.servlet.ServletBase;
import com.adobe.granite.workflow.console.servlet.WorkflowConsoleUtil;
import com.adobe.granite.workflow.exec.InboxItem;
import com.adobe.granite.workflow.exec.Participant;
import com.adobe.granite.workflow.exec.Route;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowNode;
import com.adobe.granite.workflow.model.WorkflowTransition;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.XSSFilter;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Workflow Engine POST Servlet", description="Handles GET and POST requests to workflow inbox resources")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/inbox"}), @Property(name="sling.servlet.paths", value={"/bin/workflow/inbox", ""}), @Property(name="sling.servlet.methods", value={"GET", "POST"}), @Property(name="sling.servlet.extensions", value={"json", ""}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class InboxServlet
extends ServletBase {
    private static final long serialVersionUID = -3596348616959666034L;
    private static final String CMD_ADVANCE = "advance";
    private static final String CMD_ADVANCE_BACK = "advanceBack";
    private static final String CMD_DELEGATE = "delegate";
    private static final String P_CMD = "cmd";
    private static final String P_ROUTE = "route";
    private static final String P_BACK_ROUTE = "backroute";
    private static final String P_ITEM = "item";
    private static final String P_DELEGATEE = "delegatee";
    public static final String TYPE_JAVA_OBJECT = "JAVA_OBJECT";
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    public static final String TYPE_URL = "URL";
    public static final String TYPE_BINARY = "BINARY";
    private static final String[] META_DATA_EXCLUDES = new String[]{"cmd", "item", "route", "backroute", "delegatee"};
    @Reference(policy=ReferencePolicy.STATIC)
    private XSSFilter xss;
    private static final String FAILURE_ROUTE = "retry-current-step";
    private static final String FAILURE_ITEM_TYPE = "FailureItem";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        ResultSet items = null;
        try {
            items = wfSession.getActiveInboxItems(0L, -1L, null);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        writer.setTidy(true);
        try {
            writer.array();
            for (InboxItem item : (InboxItem[])items.getItems()) {
                writer.object();
                JSONUtil.writeWithProtected((JSONWriter)writer, (String)"uri", (String)(request.getContextPath() + item.getId()), (XSSFilter)this.xss);
                if (item.getCurrentAssignee() != null) {
                    JSONUtil.writeWithProtected((JSONWriter)writer, (String)"currentAssignee", (String)item.getCurrentAssignee(), (XSSFilter)this.xss);
                }
                if (item.getTimeStarted() != null) {
                    writer.key("startTime").value(item.getTimeStarted().getTime());
                }
                if (item.getTimeEnded() != null) {
                    writer.key("endTime").value(item.getTimeEnded().getTime());
                }
                if (item instanceof WorkItem) {
                    String comment;
                    WorkItem workItem = (WorkItem)item;
                    WorkflowData workflowData = workItem.getWorkflowData();
                    if (workflowData != null && workflowData.getPayloadType() != null) {
                        JSONUtil.writeWithProtected((JSONWriter)writer, (String)"payloadType", (String)workflowData.getPayloadType(), (XSSFilter)this.xss);
                        if (workflowData.getPayload() != null && (TYPE_JCR_PATH.equals(workflowData.getPayloadType()) || TYPE_JCR_UUID.equals(workflowData.getPayloadType()) || TYPE_URL.equals(workflowData.getPayloadType()))) {
                            JSONUtil.writeWithProtected((JSONWriter)writer, (String)"payload", (String)workflowData.getPayload().toString(), (XSSFilter)this.xss);
                        }
                    }
                    if ((comment = this.getComment(workItem)) != null && !comment.equals("")) {
                        JSONUtil.writeWithProtected((JSONWriter)writer, (String)"comment", (String)comment, (XSSFilter)this.xss);
                    }
                }
                JSONUtil.writeWithProtected((JSONWriter)writer, (String)"type", (String)item.getItemType(), (XSSFilter)this.xss);
                writer.endObject();
            }
            writer.endArray();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getComment(WorkItem workItem) {
        String comment = null;
        if (workItem.getNode().getType().equals("PROCESS")) {
            comment = (String)workItem.getMetaDataMap().get("failureMessage", String.class);
        } else if (workItem.getNode().getType().equals("PARTICIPANT") || workItem.getNode().getType().equals("DYNAMIC_PARTICIPANT")) {
            comment = (String)workItem.getMetaDataMap().get("comment", String.class);
        }
        return comment;
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block22: {
            WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
            RequestParameterMap params = request.getRequestParameterMap();
            RequestParameter cmd = params.getValue(P_CMD);
            if (cmd == null) {
                RequestParameter itemIdParam = params.getValue(P_ITEM);
                RequestParameter routeIdParam = params.getValue(P_ROUTE);
                RequestParameter backRouteIdParam = params.getValue(P_BACK_ROUTE);
                RequestParameter delegateeIdParam = params.getValue(P_DELEGATEE);
                try {
                    if (itemIdParam != null && routeIdParam != null) {
                        this.advance(params, wfSession, itemIdParam.getString(), routeIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced");
                        break block22;
                    }
                    if (itemIdParam != null && backRouteIdParam != null) {
                        this.advanceBack(params, wfSession, itemIdParam.getString(), backRouteIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced back");
                        break block22;
                    }
                    if (itemIdParam != null && delegateeIdParam != null) {
                        this.delegate(response, wfSession, params, itemIdParam.getString(), delegateeIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Work Item(s) delegated");
                        break block22;
                    }
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                }
                catch (WorkflowException e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                RequestParameter[] itemIdParams = params.getValues(P_ITEM);
                if (CMD_ADVANCE.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_ROUTE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.advance(response, params, wfSession, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else if (CMD_DELEGATE.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_DELEGATEE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.delegate(response, wfSession, params, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else if (CMD_ADVANCE_BACK.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_BACK_ROUTE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.advanceBack(response, wfSession, params, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else {
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                }
            }
        }
    }

    private Map<String, String> collectParams(String namePrefix, SlingHttpServletResponse response, RequestParameterMap params, RequestParameter[] itemIdParams) {
        HashMap<String, String> p = new HashMap<String, String>();
        for (RequestParameter itemIdParam : itemIdParams) {
            String itemId = itemIdParam.getString();
            RequestParameter param = params.getValue(namePrefix + "-" + itemId);
            if (param == null) {
                this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                return null;
            }
            String val = param.getString();
            p.put(itemId, val);
        }
        return p;
    }

    private void delegate(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, Map<String, String> p) throws AccessControlException, WorkflowException {
        for (String itemId : p.keySet()) {
            String delegateeId = p.get(itemId);
            this.delegate(response, wfSession, params, itemId, delegateeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Work item(s) delegated");
    }

    private void delegate(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, String itemId, String delegateeId) throws WorkflowException {
        boolean delegated = false;
        WorkItem item = wfSession.getWorkItem(itemId);
        Iterator delegatees = wfSession.getDelegates(item);
        while (delegatees.hasNext()) {
            Participant delegatee = (Participant)delegatees.next();
            if (!delegatee.getID().equals(delegateeId)) continue;
            this.updateMetaData(params, item);
            wfSession.delegateWorkItem(item, delegatee);
            delegated = true;
            break;
        }
        if (!delegated) {
            this.sendResponse((HttpServletResponse)response, 500, "Delegatee '" + delegateeId + "' not found");
            return;
        }
    }

    private void advanceBack(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, Map<String, String> p) throws WorkflowException {
        for (String itemId : p.keySet()) {
            String routeId = p.get(itemId);
            this.advanceBack(params, wfSession, itemId, routeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced back");
    }

    private void advanceBack(RequestParameterMap params, WorkflowSession wfSession, String itemId, String routeId) throws WorkflowException {
        WorkItem item = wfSession.getWorkItem(itemId);
        List routes = wfSession.getBackRoutes(item, true);
        this.findRouteAndAdvance(wfSession, params, routeId, item, routes);
    }

    private void advance(SlingHttpServletResponse response, RequestParameterMap params, WorkflowSession wfSession, Map<String, String> p) throws WorkflowException {
        for (String itemId : p.keySet()) {
            String routeId = p.get(itemId);
            this.advance(params, wfSession, itemId, routeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced");
    }

    private void advance(RequestParameterMap params, WorkflowSession wfSession, String itemId, String routeId) throws WorkflowException {
        WorkItem item = wfSession.getWorkItem(itemId);
        List routes = wfSession.getRoutes(item, true);
        this.findRouteAndAdvance(wfSession, params, routeId, item, routes);
    }

    private void findRouteAndAdvance(WorkflowSession wfSession, RequestParameterMap params, String routeId, WorkItem item, List<Route> routes) throws WorkflowException {
        if (FAILURE_ROUTE.equals(routeId) && FAILURE_ITEM_TYPE.equals(item.getItemSubType())) {
            WorkflowConsoleUtil.retryStep(wfSession, item);
        } else {
            boolean foundRoute = false;
            for (Route route : routes) {
                WorkflowNode node;
                String cRouteId = route.getId();
                if (cRouteId.equals(routeId)) {
                    this.updateMetaData(params, item);
                    wfSession.complete(item, route);
                    foundRoute = true;
                    break;
                }
                if (!routeId.contains("@") || !(node = ((WorkflowTransition)route.getDestinations().get(0)).getTo()).getType().equals("PARTICIPANT")) continue;
                String participant = (String)node.getMetaDataMap().get("PARTICIPANT", String.class);
                if (!routeId.startsWith(cRouteId + "@") || !routeId.endsWith("@" + participant)) continue;
                this.updateMetaData(params, item);
                wfSession.complete(item, route);
                foundRoute = true;
                break;
            }
            if (!foundRoute) {
                throw new WorkflowException("Route not found");
            }
        }
    }

    protected void updateMetaData(RequestParameterMap params, WorkItem item) {
        MetaDataMap metaData = item.getMetaDataMap();
        RequestParameter cmd = params.getValue(P_CMD);
        if (cmd == null) {
            List<String> excludes = Arrays.asList(DEFAULT_META_DATA_EXCLUDES);
            for (String key : params.keySet()) {
                if (excludes.contains(key) || this.getMetaDataExcludes(params).contains(key)) continue;
                this.setMetadataFromRequestParameter(metaData, params, key);
            }
        } else {
            String suffix = "-" + item.getId();
            RequestParameter[] itemIdParams = params.getValues(P_ITEM);
            List<String> excludes = Arrays.asList(DEFAULT_META_DATA_EXCLUDES);
            for (String key : params.keySet()) {
                if (excludes.contains(key) || this.getMetaDataExcludes(params).contains(key)) continue;
                boolean hasSuffix = false;
                if (key.endsWith(suffix)) {
                    RequestParameter para = params.getValue(key);
                    key = key.substring(0, key.indexOf(suffix));
                    metaData.put((Object)key, (Object)para.getString());
                    hasSuffix = true;
                } else {
                    for (RequestParameter itemIdParam : itemIdParams) {
                        if (!key.endsWith("-" + itemIdParam.getString())) continue;
                        hasSuffix = true;
                        break;
                    }
                }
                if (hasSuffix) continue;
                this.setMetadataFromRequestParameter(metaData, params, key);
            }
        }
    }

    private void setMetadataFromRequestParameter(MetaDataMap metaData, RequestParameterMap params, String key) {
        RequestParameter[] paraValues = params.getValues(key);
        if (paraValues != null && paraValues.length > 0) {
            if (paraValues.length == 1) {
                metaData.put((Object)key, (Object)paraValues[0].getString());
            } else {
                String[] values = new String[paraValues.length];
                for (int index = 0; index < values.length; ++index) {
                    values[index] = paraValues[index].getString();
                }
                metaData.put((Object)key, (Object)values);
            }
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(META_DATA_EXCLUDES));
        for (String name : params.keySet()) {
            if (!name.startsWith("route-") && !name.startsWith("backroute-") && !name.startsWith("delegatee-")) continue;
            excludes.add(name);
        }
        return excludes;
    }

    protected void bindXss(XSSFilter xSSFilter) {
        this.xss = xSSFilter;
    }

    protected void unbindXss(XSSFilter xSSFilter) {
        if (this.xss == xSSFilter) {
            this.xss = null;
        }
    }
}

