/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.servlet.ServletBase;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Workflow Engine POST Servlet", description="Handles POST requests to the workflow instances resource")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/instances"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class InstancesServlet
extends ServletBase {
    private static final long serialVersionUID = 2031517619398541804L;
    private static final String PAYLOAD_TYPE_PARAM_NAME = "payloadType";
    private static final String PAYLOAD_PARAM_NAME = "payload";
    private static final String MODEL_PARAM_NAME = "model";
    private static final String[] META_DATA_EXCLUDES = new String[]{"payloadType", "payload", "model"};

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        RequestParameter modelParam = params.getValue(MODEL_PARAM_NAME);
        RequestParameter typeParam = params.getValue(PAYLOAD_TYPE_PARAM_NAME);
        RequestParameter[] payloadParams = params.getValues(PAYLOAD_PARAM_NAME);
        if (modelParam != null && payloadParams != null && typeParam != null) {
            String modelId = modelParam.getString();
            String payloadType = typeParam.getString();
            String url = "";
            for (RequestParameter payloadParam : payloadParams) {
                try {
                    WorkflowModel model = wfSession.getModel(modelId);
                    if (model != null) {
                        WorkflowData data = wfSession.newWorkflowData(payloadType, (Object)payloadParam.getString());
                        HashMap<String, Object> metaData = new HashMap<String, Object>();
                        this.updateMetaData(params, metaData);
                        Workflow workflow = wfSession.startWorkflow(model, data, metaData);
                        url = this.getUrl(request, workflow.getId());
                        continue;
                    }
                    this.sendResponse((HttpServletResponse)response, 400, "workflow model not found");
                }
                catch (WorkflowException e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                    return;
                }
            }
            this.sendResourceCreatedResponse((HttpServletResponse)response, url);
        } else {
            this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Arrays.asList(META_DATA_EXCLUDES);
    }
}

