/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.launcher.ConfigEntry;
import com.adobe.granite.workflow.launcher.WorkflowLauncher;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.XSSFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/workflow/launcher"}), @Property(name="sling.servlet.methods", value={"GET", "POST"}), @Property(name="sling.servlet.extensions", value={"json", ""}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class LauncherServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1509019996493073156L;
    private static final String LAUNCHER_CONFIG_ROOT_PATH = "/etc/workflow/launcher/config";
    @Reference(policy=ReferencePolicy.STATIC)
    private XSSFilter xss;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceBundle resourceBundle = request.getResourceBundle(null);
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        Session sess = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (request.getRequestPathInfo().getSelectors().length > 0 && request.getRequestPathInfo().getSelectors()[0].equals("nodetypes")) {
            try {
                NodeTypeManager ntMgr = sess.getWorkspace().getNodeTypeManager();
                NodeTypeIterator itr = ntMgr.getPrimaryNodeTypes();
                JSONWriter writer = new JSONWriter((Writer)response.getWriter());
                writer.object();
                writer.key("nodetypes");
                writer.array();
                while (itr.hasNext()) {
                    NodeType nt = itr.nextNodeType();
                    writer.object();
                    writer.key("name").value((Object)nt.getName());
                    writer.key("value").value((Object)nt.getName());
                    writer.endObject();
                }
                writer.endArray();
                writer.key("results").value(itr.getSize());
                writer.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServletException((Throwable)e);
            }
        }
        int start = 0;
        String startParam = request.getParameter("start");
        if (startParam != null && !startParam.equals("")) {
            start = Integer.valueOf(startParam);
        }
        int limit = -1;
        String limitParam = request.getParameter("limit");
        if (limitParam != null && !limitParam.equals("")) {
            limit = Integer.valueOf(limitParam);
        }
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.object();
            writer.key("configs");
            writer.array();
            WorkflowLauncher wfLauncher = (WorkflowLauncher)request.getResourceResolver().adaptTo(WorkflowLauncher.class);
            Iterator iterator = wfLauncher.getConfigEntries();
            int count = 0;
            while (iterator.hasNext()) {
                ConfigEntry entry = (ConfigEntry)iterator.next();
                if (++count < start || count > limit) continue;
                writer.object();
                writer.key("id").value((Object)entry.getId());
                writer.key("eventType").value((Object)resourceBundle.getString(this.getEventTypeAsString(entry.getEventType())));
                writer.key("nodetype").value((Object)entry.getNodetype());
                JSONUtil.writeProtected((JSONWriter)writer, (String)"glob", (String)entry.getGlob(), (XSSFilter)this.xss);
                JSONUtil.writeProtected((JSONWriter)writer, (String)"whereClause", (String)entry.getWhereClause(), (XSSFilter)this.xss);
                String workflow = entry.getWorkflow();
                writer.key("workflow").value((Object)workflow);
                try {
                    Node wfNode;
                    if (sess.itemExists(workflow) && (wfNode = (Node)sess.getItem(workflow)).hasProperty("title")) {
                        JSONUtil.writeProtected((JSONWriter)writer, (String)"workflowTitle", (String)wfNode.getProperty("title").getString(), (XSSFilter)this.xss);
                    }
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                JSONUtil.writeProtected((JSONWriter)writer, (String)"description", (String)entry.getDescription(), (XSSFilter)this.xss);
                writer.key("enabled").value(entry.isEnabled());
                JSONUtil.writeProtected((JSONWriter)writer, (String)"exclude", (String)this.serialize(entry.getExcludeList()), (XSSFilter)this.xss);
                writer.key("runModes").value((Object)this.serialize(entry.getRunModes()));
                writer.endObject();
            }
            writer.endArray();
            writer.key("results").value((long)count);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        catch (WorkflowException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block15: {
            ResourceBundle resBundle = request.getResourceBundle(null);
            RequestParameterMap params = request.getRequestParameterMap();
            Session userSession = (Session)request.getResourceResolver().adaptTo(Session.class);
            WorkflowLauncher wfLauncher = (WorkflowLauncher)request.getResourceResolver().adaptTo(WorkflowLauncher.class);
            if (params.getValue("delete") != null) {
                try {
                    String path = params.getValue("delete").getString();
                    if (this.isConfigNode(userSession, path) && this.hasPermission(userSession, path, "remove")) {
                        wfLauncher.removeConfigEntry(path);
                        this.sendResponse((HttpServletResponse)response, 200, resBundle.getString("Entry deleted"));
                        break block15;
                    }
                    this.sendResponse((HttpServletResponse)response, 405, "Not allowed to delete launcher config");
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else if (params.getValue("add") != null) {
                String eventType = params.getValue("eventType").getString();
                String description = params.getValue("description").getString();
                String modelId = params.getValue("workflow").getString();
                String condition = params.getValue("condition").getString();
                String glob = params.getValue("glob").getString();
                String nodetype = params.getValue("nodetype").getString();
                boolean enabled = Boolean.valueOf(params.getValue("enabled").getString());
                String excludeList = params.getValue("excludeList").getString();
                String runModes = params.getValue("runModes").getString();
                try {
                    if (this.isConfigNode(userSession, LAUNCHER_CONFIG_ROOT_PATH) && this.hasPermission(userSession, LAUNCHER_CONFIG_ROOT_PATH, "add_node")) {
                        ConfigEntry config = new ConfigEntry(Integer.valueOf(eventType).intValue(), glob, nodetype, condition, modelId, null, description, enabled, Arrays.asList(excludeList.split(",")), Arrays.asList(runModes.split(",")));
                        wfLauncher.addConfigEntry(config);
                        this.sendResponse((HttpServletResponse)response, 200, resBundle.getString("Entry added"));
                        break block15;
                    }
                    this.sendResponse((HttpServletResponse)response, 405, "Not allowed to add launcher config");
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else if (params.getValue("edit") != null) {
                String eventType = params.getValue("eventType").getString();
                String description = params.getValue("description").getString();
                String modelId = params.getValue("workflow").getString();
                String condition = params.getValue("condition").getString();
                String glob = params.getValue("glob").getString();
                String nodetype = params.getValue("nodetype").getString();
                boolean enabled = Boolean.valueOf(params.getValue("enabled").getString());
                String excludeList = params.getValue("excludeList").getString();
                String runModes = params.getValue("runModes").getString();
                try {
                    String path = params.getValue("edit").getString();
                    if (this.isConfigNode(userSession, path) && this.hasPermission(userSession, path, "set_property")) {
                        wfLauncher.editConfigEntry(params.getValue("edit").getString(), new ConfigEntry(Integer.valueOf(eventType).intValue(), glob, nodetype, condition, modelId, null, description, enabled, Arrays.asList(excludeList.split(",")), Arrays.asList(runModes.split(","))));
                        this.sendResponse((HttpServletResponse)response, 200, resBundle.getString("Entry edited"));
                        break block15;
                    }
                    this.sendResponse((HttpServletResponse)response, 405, "Not allowed to edit launcher config");
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                this.sendResponse((HttpServletResponse)response, 405, "unsupported edit operation");
            }
        }
    }

    private boolean isConfigNode(Session userSession, String path) throws RepositoryException {
        boolean isConfigNode = false;
        if (userSession != null && path != null) {
            Node node = userSession.getNode(path);
            isConfigNode = node != null && node.getPath().startsWith(LAUNCHER_CONFIG_ROOT_PATH);
        }
        return isConfigNode;
    }

    private boolean hasPermission(Session userSession, String path, String action) throws RepositoryException {
        boolean hasPermission = false;
        if (userSession != null && path != null && action != null) {
            hasPermission = userSession.hasPermission(path, action);
        }
        return hasPermission;
    }

    private void sendResponse(HttpServletResponse response, int status, String message) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(status, message);
        htmlResponse.setTitle(message);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private String getEventTypeAsString(int eventType) {
        String event = "[undefined]";
        switch (eventType) {
            case 1: {
                event = "Node Created";
                break;
            }
            case 2: {
                event = "Node removed";
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                event = "Node modified";
            }
        }
        return event;
    }

    private String serialize(List<String> excludeList) {
        String str = "";
        String comma = "";
        for (String item : excludeList) {
            str = str + comma + item;
            comma = ",";
        }
        return str;
    }

    protected void bindXss(XSSFilter xSSFilter) {
        this.xss = xSSFilter;
    }

    protected void unbindXss(XSSFilter xSSFilter) {
        if (this.xss == xSSFilter) {
            this.xss = null;
        }
    }
}

