/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.servlet.ServletBase;
import com.adobe.granite.workflow.model.VersionException;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.workflow.serialization.SerializationService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Workflow Engine POST Servlet", description="Handles POST requests to workflow model resources")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/model"}), @Property(name="sling.servlet.methods", value={"GET", "POST", "DELETE"}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class ModelServlet
extends ServletBase {
    private static final long serialVersionUID = -2863410737457137929L;
    private static final String NT_PAGE_CONTENT = "cq:PageContent";
    private static final String HIDDEN_PROPERTY = "hidden";
    @Reference(policy=ReferencePolicy.STATIC)
    private SerializationService serSvc;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        Node node = (Node)request.getResource().adaptTo(Node.class);
        response.setContentType(this.serSvc.getMimeType("JSON"));
        String[] selectors = request.getRequestPathInfo().getSelectors();
        try {
            if (selectors.length == 0) {
                WorkflowModel model = wfSession.getModel(node.getPath());
                this.sendModel(response, model);
            } else if (selectors.length == 2) {
                WorkflowModel model = wfSession.getModel(node.getPath(), selectors[0] + "." + selectors[1]);
                this.sendModel(response, model);
            } else {
                this.sendResponse((HttpServletResponse)response, 400, "Unknown version selector");
            }
        }
        catch (VersionException e) {
            this.sendResponse((HttpServletResponse)response, 404, e.getMessage());
        }
        catch (Exception e) {
            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
        }
    }

    private void sendModel(SlingHttpServletResponse response, WorkflowModel model) throws Exception {
        if (model != null) {
            response.getWriter().write(this.serSvc.serialize(model, "JSON"));
        } else {
            this.sendResponse((HttpServletResponse)response, 404, "Model does not exist");
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String methodOverride = request.getHeader("X-HTTP-Method-Override");
        if (methodOverride != null && methodOverride.equals("DELETE")) {
            this.doDelete(request, response);
            return;
        }
        this.doPut(request, response);
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        RequestParameter modelPara = params.getValue("model");
        RequestParameter typePara = params.getValue("type");
        if (modelPara != null && typePara != null) {
            try {
                WorkflowModel model = this.serSvc.deserialize(modelPara.getString(), typePara.getString());
                wfSession.deployModel(model);
                this.sendResponse((HttpServletResponse)response, 200, "Model saved");
            }
            catch (Exception e) {
                this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
            }
        } else {
            this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
        }
    }

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        Node node = (Node)resource.adaptTo(Node.class);
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        try {
            wfSession.deleteModel(node.getPath());
            Node parentNode = node.getParent();
            if (parentNode.isNodeType(NT_PAGE_CONTENT)) {
                parentNode.setProperty(HIDDEN_PROPERTY, true);
                session.save();
            }
        }
        catch (Exception e) {
            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
        }
        this.sendResponse((HttpServletResponse)response, 204, "Model deleted");
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    protected void bindSerSvc(SerializationService serializationService) {
        this.serSvc = serializationService;
    }

    protected void unbindSerSvc(SerializationService serializationService) {
        if (this.serSvc == serializationService) {
            this.serSvc = null;
        }
    }
}

