/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.servlet.ServletBase;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.workflow.serialization.SerializationService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Workflow Engine POST Servlet", description="Handles POST requests to the workflow models resource")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/models"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class ModelsServlet
extends ServletBase {
    private static final long serialVersionUID = 937308391948022139L;
    @Reference(policy=ReferencePolicy.STATIC)
    private SerializationService serSvc;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        RequestParameter reqPara = null;
        RequestParameter typePara = null;
        reqPara = params.getValue("delete");
        if (reqPara != null) {
            try {
                wfSession.deleteModel(reqPara.getString());
            }
            catch (Exception e) {
                this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
            }
        } else {
            reqPara = params.getValue("title");
            if (reqPara != null) {
                String name = reqPara.getString();
                try {
                    WorkflowModel model = wfSession.createNewModel(name);
                    this.sendResourceCreatedResponse((HttpServletResponse)response, this.getUrl(request, model.getId()));
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                reqPara = params.getValue("model");
                if (reqPara != null && (typePara = params.getValue("type")) != null) {
                    this.deployModelDefinition(request, response, wfSession, reqPara, typePara);
                } else {
                    reqPara = params.getValue("modelfile");
                    if (reqPara != null && (typePara = params.getValue("type")) != null) {
                        this.deployModelDefinition(request, response, wfSession, reqPara, typePara);
                    } else {
                        this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                    }
                }
            }
        }
    }

    private void deployModelDefinition(SlingHttpServletRequest request, SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameter reqPara, RequestParameter typePara) {
        try {
            WorkflowModel model = this.serSvc.deserialize(reqPara.getString(), typePara.getString());
            wfSession.deployModel(model);
            this.sendResourceCreatedResponse((HttpServletResponse)response, this.getUrl(request, model.getId()));
        }
        catch (Exception e) {
            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    protected void bindSerSvc(SerializationService serializationService) {
        this.serSvc = serializationService;
    }

    protected void unbindSerSvc(SerializationService serializationService) {
        if (this.serSvc == serializationService) {
            this.serSvc = null;
        }
    }
}

