/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.exec.ParticipantStepChooser;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.XSSFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/participant_chooser"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selector", value={"list"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Dynamic Participant Chooser getter"})})
public class ParticipantChooserListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(ParticipantChooserListServlet.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private XSSFilter xss;
    private ComponentContext context;
    private static final String SCRIPT_ROOT = "/etc/workflow/scripts";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.array();
            this.writeChooserImpl(writer);
            Node scriptRoot = (Node)request.getResourceResolver().getResource(SCRIPT_ROOT).adaptTo(Node.class);
            this.writeScripts(writer, scriptRoot);
            writer.endArray();
        }
        catch (InvalidSyntaxException e) {
            throw new ServletException("Could not lookup java processes.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup scripts.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }

    private void writeScripts(JSONWriter writer, Node scriptRoot) throws RepositoryException, JSONException {
        NodeIterator scripts = scriptRoot.getNodes();
        while (scripts.hasNext()) {
            Node script = scripts.nextNode();
            if (script.isNodeType("nt:folder")) {
                this.writeScripts(writer, script);
                continue;
            }
            try {
                String title = this.getScriptTitle(script);
                String path = this.getScriptPath(script);
                this.writeParticipantChooser(writer, title, path);
            }
            catch (RepositoryException re) {}
        }
    }

    private void writeParticipantChooser(JSONWriter writer, String text, String value) throws JSONException {
        writer.object();
        JSONUtil.writeProtected((JSONWriter)writer, (String)"text", (String)text, (XSSFilter)this.xss);
        writer.key("value").value((Object)value);
        writer.endObject();
    }

    private String getScriptTitle(Node scriptNode) throws ValueFormatException, RepositoryException {
        String title = scriptNode.getPath();
        try {
            Node jcrContent = scriptNode.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resovling jcr:title property form scipt's jcr:content node. Fallback to script path");
        }
        return title;
    }

    private String getScriptPath(Node scriptNode) throws RepositoryException {
        return scriptNode.getPath();
    }

    private void writeChooserImpl(JSONWriter writer) throws JSONException, InvalidSyntaxException {
        ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(ParticipantStepChooser.class.getName(), null);
        ServiceReference[] cqRefs = this.context.getBundleContext().getServiceReferences("com.day.cq.workflow.exec.ParticipantStepChooser", null);
        HashMap<String, ServiceReference> referenceMap = new HashMap<String, ServiceReference>((refs == null ? 0 : refs.length) + (cqRefs == null ? 0 : cqRefs.length));
        ParticipantChooserListServlet.buildMap(cqRefs, referenceMap);
        ParticipantChooserListServlet.buildMap(refs, referenceMap);
        for (Map.Entry entry : referenceMap.entrySet()) {
            this.writeParticipantChooser(writer, (String)entry.getKey(), (String)((ServiceReference)entry.getValue()).getProperty("service.pid"));
        }
    }

    private static void buildMap(ServiceReference[] serviceReferences, Map<String, ServiceReference> referenceMap) {
        if (serviceReferences == null) {
            return;
        }
        for (ServiceReference ref : serviceReferences) {
            Object pid = ref.getProperty("service.pid");
            Object label = ref.getProperty("chooser.label");
            if (!(pid instanceof String)) continue;
            String name = (String)pid;
            if (label != null) {
                name = (String)label;
            }
            referenceMap.put(name, ref);
        }
    }

    protected void bindXss(XSSFilter xSSFilter) {
        this.xss = xSSFilter;
    }

    protected void unbindXss(XSSFilter xSSFilter) {
        if (this.xss == xSSFilter) {
            this.xss = null;
        }
    }
}

