/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.XSSFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/process"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Process getter"})})
public class ProcessListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    @Reference(policy=ReferencePolicy.STATIC)
    private XSSFilter xss;
    private final Logger log = LoggerFactory.getLogger(ProcessListServlet.class);
    private ComponentContext context;
    private static final String SCRIPT_ROOT = "/etc/workflow/scripts";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        boolean list = false;
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors.length == 1 && selectors[0].equals("list")) {
            list = true;
        }
        JSONWriter w = new JSONWriter((Writer)response.getWriter());
        try {
            ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(WorkflowProcess.class.getName(), null);
            ServiceReference[] cqRefs = this.context.getBundleContext().getServiceReferences("com.day.cq.workflow.exec.WorkflowProcess", null);
            HashMap<String, ServiceReference> referenceMap = new HashMap<String, ServiceReference>((refs == null ? 0 : refs.length) + (cqRefs == null ? 0 : cqRefs.length));
            ProcessListServlet.buildMap(cqRefs, referenceMap);
            ProcessListServlet.buildMap(refs, referenceMap);
            if (list) {
                w.array();
            } else {
                w.object().key("processes").array();
            }
            int count = 0;
            for (Map.Entry entry : referenceMap.entrySet()) {
                Object pid = ((ServiceReference)entry.getValue()).getProperty("service.pid");
                Object label = ((ServiceReference)entry.getValue()).getProperty("process.label");
                if (!(pid instanceof String)) continue;
                String name = (String)pid;
                if (label != null) {
                    name = (String)label;
                }
                w.object();
                if (list) {
                    JSONUtil.writeProtected((JSONWriter)w, (String)"text", (String)name, (XSSFilter)this.xss);
                    w.key("value").value(pid);
                } else {
                    w.key("rid").value(pid);
                    w.key("label").value((Object)name);
                }
                w.endObject();
                ++count;
            }
            Resource scriptResource = request.getResourceResolver().getResource(SCRIPT_ROOT);
            if (scriptResource != null) {
                Node scriptRoot = (Node)scriptResource.adaptTo(Node.class);
                count = this.getScripts(scriptRoot, count, list, w);
            }
            if (list) {
                w.endArray();
            } else {
                w.endArray().key("results").value((long)count).endObject();
            }
        }
        catch (InvalidSyntaxException e) {
            throw new ServletException("Could not lookup java processes.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup scripts.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    private static void buildMap(ServiceReference[] serviceReferences, Map<String, ServiceReference> referenceMap) {
        if (serviceReferences != null) {
            for (ServiceReference ref : serviceReferences) {
                String key = (String)ref.getProperty("process.label");
                if (key == null || key.trim().equals("")) {
                    key = (String)ref.getProperty("service.pid");
                }
                referenceMap.put(key, ref);
            }
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }

    private int getScripts(Node scriptRoot, int count, boolean list, JSONWriter w) throws RepositoryException, JSONException {
        NodeIterator scripts = scriptRoot.getNodes();
        while (scripts.hasNext()) {
            Node script = scripts.nextNode();
            if (script.isNodeType("nt:folder")) {
                count = this.getScripts(script, count, list, w);
                continue;
            }
            try {
                w.object();
                String title = this.getScriptTitle(script);
                String path = this.getScriptPath(script);
                if (list) {
                    JSONUtil.writeProtected((JSONWriter)w, (String)"text", (String)title, (XSSFilter)this.xss);
                    w.key("value").value((Object)path);
                } else {
                    w.key("rid").value((Object)path);
                    w.key("label").value((Object)title);
                }
                w.endObject();
                ++count;
            }
            catch (RepositoryException re) {}
        }
        return count;
    }

    private String getScriptTitle(Node scriptNode) throws ValueFormatException, RepositoryException {
        String title = scriptNode.getPath();
        try {
            Node jcrContent = scriptNode.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resolving jcr:title property form script's jcr:content node. Fallback to script path");
        }
        return title;
    }

    private String getScriptPath(Node scriptNode) throws RepositoryException {
        return scriptNode.getPath();
    }

    protected void bindXss(XSSFilter xSSFilter) {
        this.xss = xSSFilter;
    }

    protected void unbindXss(XSSFilter xSSFilter) {
        if (this.xss == xSSFilter) {
            this.xss = null;
        }
    }
}

