/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.servlet.ServletBase;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.event.JobStatusProvider;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/workflow/restarter"}), @Property(name="sling.servlet.methods", value={"POST", ""}), @Property(name="service.description", value={"Workflow Publish Process"})})
public class RestarterServlet
extends ServletBase {
    private static final Logger log = LoggerFactory.getLogger(RestarterServlet.class);
    private static final long serialVersionUID = 2171661388034822790L;
    private static final String PATH_PARAM_NAME = "path";
    @Reference(policy=ReferencePolicy.STATIC)
    private JobStatusProvider jobStatusProvider;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block6: {
            RequestParameterMap params = request.getRequestParameterMap();
            WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
            RequestParameter path = params.getValue(PATH_PARAM_NAME);
            if (path != null) {
                try {
                    Workflow workflow = wfSession.getWorkflow(path.toString());
                    Collection<Event> jobs = this.getEvents(this.jobStatusProvider, wfSession);
                    if (this.isStale(workflow, jobs)) {
                        wfSession.restartWorkflow(workflow);
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow " + workflow.getId() + " restarted");
                        break block6;
                    }
                    log.debug("No need to restart workflow: " + workflow.getId());
                }
                catch (IllegalStateException e) {
                    this.sendResponse((HttpServletResponse)response, 409, e.getMessage());
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
            }
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    private Collection<Event> getEvents(JobStatusProvider jobStatusProvider, WorkflowSession wfSession) {
        ArrayList<Event> wfJobs = new ArrayList<Event>();
        WorkflowModel[] models = new WorkflowModel[]{};
        try {
            models = wfSession.getModels();
        }
        catch (WorkflowException we) {
            log.error("Cannot retrieve workflow model list", (Throwable)we);
        }
        for (WorkflowModel model : models) {
            String topicName = "com/adobe/granite/workflow/job" + model.getId();
            wfJobs.addAll(jobStatusProvider.getAllJobs(topicName, new Map[0]));
        }
        Collection toJobs = jobStatusProvider.getAllJobs("com/adobe/granite/workflow/timeout/job", new Map[0]);
        wfJobs.addAll(toJobs);
        log.debug("WORKFLOW JOBS: " + wfJobs.size());
        return wfJobs;
    }

    private boolean isStale(Workflow workflow, Collection<Event> wfJobs) {
        String currentJobs = (String)workflow.getWorkflowData().getMetaDataMap().get("currentJobs", String.class);
        if (currentJobs != null) {
            if (currentJobs.startsWith("_,_")) {
                currentJobs = currentJobs.substring("_,_".length());
            }
            if (!currentJobs.equals("")) {
                String[] jobs;
                for (String job : jobs = currentJobs.split("_,_")) {
                    for (Event event : wfJobs) {
                        String jobId = (String)event.getProperty("com.adobe.granite.workflow.jobid");
                        if (jobId == null || !jobId.equals(job)) continue;
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    protected void bindJobStatusProvider(JobStatusProvider jobStatusProvider) {
        this.jobStatusProvider = jobStatusProvider;
    }

    protected void unbindJobStatusProvider(JobStatusProvider jobStatusProvider) {
        if (this.jobStatusProvider == jobStatusProvider) {
            this.jobStatusProvider = null;
        }
    }
}

