/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletBase
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 8498347475694730617L;
    protected static final String[] DEFAULT_META_DATA_EXCLUDES = new String[]{"_charset_", ":status"};

    protected void sendResponse(HttpServletResponse response, int status, String message) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(status, message);
        htmlResponse.setTitle(message);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    protected void sendResourceCreatedResponse(HttpServletResponse response, String url) {
        response.setCharacterEncoding("utf-8");
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(201, "Created");
        htmlResponse.setTitle("Created");
        htmlResponse.setLocation(url);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    protected String getUrl(SlingHttpServletRequest request, String uri) {
        return "http://" + request.getLocalName() + ":" + request.getLocalPort() + request.getContextPath() + uri;
    }

    protected void updateMetaData(RequestParameterMap params, Map<String, Object> metaData) {
        List<String> excludes = Arrays.asList(DEFAULT_META_DATA_EXCLUDES);
        for (String key : params.keySet()) {
            if (excludes.contains(key) || this.getMetaDataExcludes(params).contains(key)) continue;
            RequestParameter para = params.getValue(key);
            metaData.put(key, para.getString());
        }
    }

    protected abstract List<String> getMetaDataExcludes(RequestParameterMap var1);
}

