/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtil {
    private static final Logger log = LoggerFactory.getLogger(ServletUtil.class);
    public static final String JCR_TITLE = "jcr:title";
    public static final String JCR_DESCRIPTION = "jcr:description";
    private static final String PROPERTY_PRINCIPAL = "rep:principalName";

    public static Authorizable findByHome(Session session, UserManager userManager, String homePath) {
        try {
            Node n;
            if (session.nodeExists(homePath) && (n = session.getNode(homePath)).hasProperty(PROPERTY_PRINCIPAL)) {
                final String pName = n.getProperty(PROPERTY_PRINCIPAL).getString();
                Principal p = new Principal(){

                    public String getName() {
                        return pName;
                    }
                };
                return userManager.getAuthorizable(p);
            }
        }
        catch (PathNotFoundException e) {
            log.debug("Could not resolve Authorizable from Home at {}, path is not a Home", (Object)e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn("Could not resolve Authorizable: failure accessing Repository: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static Authorizable getAuthorizable(UserManager userManager, String id) {
        try {
            Authorizable authorizable = userManager.getAuthorizable(id);
            if (authorizable == null) {
                throw new SlingException(String.format("No Authorizable with ID %s", authorizable), null);
            }
            return authorizable;
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), (Throwable)e);
        }
    }
}

