/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.servlet;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.xss.JSONUtil;
import com.adobe.granite.xss.XSSFilter;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/workflows"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Process getter"})})
public class WorkflowListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -4969385878052901867L;
    @Reference(policy=ReferencePolicy.STATIC)
    private XSSFilter xss;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        WorkflowModel[] models;
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        RequestParameter tagsRp = request.getRequestParameter("tags");
        String[] tags = tagsRp != null ? tagsRp.getString().trim().split(",") : new String[]{};
        RequestParameter filterStrict = request.getRequestParameter("strict");
        boolean doFilterStrict = filterStrict != null && filterStrict.getString().equals("true");
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        WorkflowSession wfSession = (WorkflowSession)request.getResourceResolver().adaptTo(WorkflowSession.class);
        try {
            models = wfSession.getModels();
        }
        catch (WorkflowException e) {
            throw new ServletException("Error fetching workflow models", (Throwable)e);
        }
        int count = 0;
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.object();
            writer.key("workflows");
            writer.array();
            for (WorkflowModel model : models) {
                if (!this.doInclude(model, tags, doFilterStrict)) continue;
                writer.object();
                writer.key("wid").value((Object)model.getId());
                JSONUtil.writeWithProtected((JSONWriter)writer, (String)"label", (String)model.getTitle(), (XSSFilter)this.xss);
                JSONUtil.writeWithProtected((JSONWriter)writer, (String)"description", (String)model.getDescription(), (XSSFilter)this.xss);
                writer.key("isCqPage").value(this.isCqPage(session, model));
                String tnPath = this.getThumbnailPath(session, model);
                if (tnPath != null) {
                    writer.key("thumbnail").value((Object)tnPath);
                }
                writer.endObject();
                ++count;
            }
            writer.endArray();
            writer.key("results").value((long)count);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isCqPage(Session session, WorkflowModel model) throws ServletException {
        try {
            Node modelNode = null;
            if (session.itemExists(model.getId())) {
                modelNode = (Node)session.getItem(model.getId());
            }
            return modelNode != null && modelNode.getParent().getName().equals("jcr:content");
        }
        catch (RepositoryException rex) {
            throw new ServletException("RepositoryException in isCqPage");
        }
    }

    private String getThumbnailPath(Session session, WorkflowModel model) throws ServletException {
        String result = null;
        try {
            String path;
            Node modelNode = null;
            if (session.itemExists(model.getId())) {
                modelNode = (Node)session.getItem(model.getId());
            }
            if (modelNode != null && modelNode.getParent().getName().equals("jcr:content") && session.itemExists(path = modelNode.getParent().getPath() + "/image/file")) {
                result = path;
            }
        }
        catch (RepositoryException rex) {
            throw new ServletException("RepositoryException looking for thumbnail path:" + (Object)((Object)rex));
        }
        return result;
    }

    private boolean doInclude(WorkflowModel model, String[] tags, boolean doStrict) {
        String[] tagStrSplits;
        if (tags.length == 0) {
            return true;
        }
        MetaDataMap metaData = model.getMetaDataMap();
        String tagStr = metaData.get("tags", String.class) != null ? (String)metaData.get("tags", String.class) : null;
        String[] stringArray = tagStrSplits = tagStr != null && !tagStr.equals("") ? tagStr.trim().split(",") : new String[]{};
        if (tagStrSplits.length == 0 && !doStrict) {
            return true;
        }
        for (String tag : tagStrSplits) {
            for (String checkTag : tags) {
                if (!checkTag.equals(tag)) continue;
                return true;
            }
        }
        return false;
    }

    protected void bindXss(XSSFilter xSSFilter) {
        this.xss = xSSFilter;
    }

    protected void unbindXss(XSSFilter xSSFilter) {
        if (this.xss == xSSFilter) {
            this.xss = null;
        }
    }
}

