/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.console.timeout.autoadvance;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.console.timeout.autoadvance.AutoAdvancer;
import com.adobe.granite.workflow.exec.Route;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.job.AbsoluteTimeoutHandler;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowTransition;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Workflow Auto Advance Process"}), @Property(name="process.label", value={"Absolute Time Auto Advancer"})})
public class AbsoluteTimeAutoAdvancer
extends AutoAdvancer
implements AbsoluteTimeoutHandler {
    protected final Logger log = LoggerFactory.getLogger(AbsoluteTimeAutoAdvancer.class);

    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
        try {
            boolean advanced = false;
            List routes = session.getRoutes(item, false);
            for (Route route : routes) {
                if (!route.hasDefault()) continue;
                String fromTitle = item.getNode().getTitle();
                String toTitle = ((WorkflowTransition)route.getDestinations().get(0)).getTo().getTitle();
                session.complete(item, route);
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
                advanced = true;
            }
            if (!advanced) {
                session.complete(item, (Route)routes.get(0));
                String fromTitle = item.getNode().getTitle();
                String toTitle = ((WorkflowTransition)((Route)routes.get(0)).getDestinations().get(0)).getTo().getTitle();
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
            }
        }
        catch (WorkflowException e) {
            this.log.error("Could not advance workflow.", (Throwable)e);
        }
    }

    public long getTimeoutDate(WorkItem workItem) {
        Long date = (Long)workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", Long.class);
        return date != null ? date : -1L;
    }
}

