/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.xss.impl;

import com.adobe.granite.xss.impl.PolicyHandler;
import com.adobe.granite.xss.impl.XSSFilterRule;
import java.util.ArrayList;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToHtmlContentContext
implements XSSFilterRule {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean check(PolicyHandler policyHandler, String str) {
        try {
            return policyHandler.getAntiSamy().scan(str).getNumberOfErrors() == 0;
        }
        catch (ScanException se) {
            throw new RuntimeException("Unable to scan input");
        }
        catch (PolicyException pe) {
            return false;
        }
    }

    public String filter(PolicyHandler policyHandler, String str) {
        try {
            this.log.debug("Protecting (HTML -> HTML) :\n{}", (Object)str);
            CleanResults results = policyHandler.getAntiSamy().scan(str);
            String cleaned = results.getCleanHTML();
            ArrayList errors = results.getErrorMessages();
            for (String error : errors) {
                this.log.info("AntiSamy warning: {}", (Object)error);
            }
            this.log.debug("Protected (HTML -> HTML):\n{}", (Object)cleaned);
            return cleaned;
        }
        catch (ScanException se) {
            throw new RuntimeException("Unable to scan input");
        }
        catch (PolicyException pe) {
            throw new RuntimeException("Unable to scan input");
        }
    }

    public boolean supportsPolicy() {
        return true;
    }
}

