/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.xss.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Policy policy;
    private AntiSamy antiSamy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyHandler(ResourceResolverFactory factory, String policyPath) throws Exception {
        ResourceResolver resolver = factory.getAdministrativeResourceResolver(null);
        try {
            Resource rsrc = resolver.getResource(policyPath);
            if (rsrc == null) {
                throw new IllegalArgumentException("Could not resolve '" + policyPath + " to a valid policy resource.");
            }
            this.log.debug("Loading policy from '{}'.", (Object)rsrc.getPath());
            InputStream policyStream = null;
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.getClass().getClassLoader());
                policyStream = (InputStream)rsrc.adaptTo(InputStream.class);
                this.policy = Policy.getInstance(policyStream);
                this.antiSamy = new AntiSamy(this.policy);
            }
            finally {
                if (policyStream != null) {
                    try {
                        policyStream.close();
                    }
                    catch (IOException ioe) {}
                }
                currentThread.setContextClassLoader(cl);
            }
        }
        finally {
            resolver.close();
        }
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public AntiSamy getAntiSamy() {
        return this.antiSamy;
    }
}

