/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.xss.impl;

import com.adobe.granite.xss.XSSAPI;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={AdapterFactory.class})
@Properties(value={@Property(name="service.description", value={"Adapter for the XSSAPI service."})})
public class XSSAPIAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(XSSAPIAdapterFactory.class);
    private static final Class<XSSAPI> XSSAPI_CLASS = XSSAPI.class;
    private static final Class<ResourceResolver> RESOURCE_RESOLVER_CLASS = ResourceResolver.class;
    private static final Class<SlingHttpServletRequest> SLING_REQUEST_CLASS = SlingHttpServletRequest.class;
    @Reference
    XSSAPI xssApi;
    @Property(name="adapters")
    public static final String[] ADAPTER_CLASSES = new String[]{XSSAPI_CLASS.getName()};
    @Property(name="adaptables")
    public static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_RESOLVER_CLASS.getName(), SLING_REQUEST_CLASS.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return this.getAdapter((SlingHttpServletRequest)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resourceResolver, Class<AdapterType> type) {
        if (resourceResolver != null && type == XSSAPI.class) {
            return (AdapterType)this.xssApi.getResourceResolverSpecificAPI(resourceResolver);
        }
        log.debug("Unable to adapt resourceResolver to type {}", (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(SlingHttpServletRequest request, Class<AdapterType> type) {
        if (request != null && type == XSSAPI.class) {
            return (AdapterType)this.xssApi.getRequestSpecificAPI(request);
        }
        log.debug("Unable to adapt resourceResolver to type {}", (Object)type.getName());
        return null;
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }
}

