/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.xss.impl;

import com.adobe.granite.xss.ProtectionContext;
import com.adobe.granite.xss.XSSAPI;
import com.adobe.granite.xss.XSSFilter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.owasp.esapi.ESAPI;

@Component
@Service(value={XSSAPI.class})
public class XSSAPIImpl
implements XSSAPI {
    @Reference
    private XSSFilter xssFilter;
    private ResourceResolver resourceResolver = null;

    public Integer getValidInteger(String integer, int defaultValue) {
        try {
            if (integer == null || integer.length() == 0) {
                return defaultValue;
            }
            return ESAPI.validator().getValidInteger("XSS", integer, -2000000000, 2000000000, false);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Long getValidLong(String source, long defaultValue) {
        try {
            if (source == null || source.length() == 0) {
                return defaultValue;
            }
            return ESAPI.validator().getValidNumber("XSS", source, -9000000000000000000L, 9000000000000000000L, false).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getValidDimension(String dimension, String defaultValue) {
        try {
            if (dimension == null || dimension.length() == 0) {
                return defaultValue;
            }
            if (dimension.matches("['\"]?auto['\"]?")) {
                return "\"auto\"";
            }
            return ESAPI.validator().getValidInteger("XSS", dimension, -10000, 10000, false).toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getValidHref(String url) {
        if (this.resourceResolver == null) {
            throw new IllegalArgumentException("HREFs must be validated with a request/resourceresolver-specific XSSAPI.");
        }
        try {
            String prefix = "<a href='";
            String suffix = "'></a>";
            String testHtml = "<a href='" + url + "'></a>";
            if (!this.xssFilter.check(ProtectionContext.HTML_HTML_CONTENT, testHtml)) {
                testHtml = "<a href='" + this.resourceResolver.map(url) + "'></a>";
            }
            String safeHtml = this.xssFilter.filter(ProtectionContext.HTML_HTML_CONTENT, testHtml);
            return safeHtml.substring("<a href='".length(), safeHtml.length() - "'></a>".length());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Deprecated
    public String getValidHref(String url, boolean isPath) {
        return this.getValidHref(url);
    }

    public String getValidJSToken(String token, String defaultValue) {
        String q = (token = token.trim()).substring(0, 1);
        if (q.matches("['\"]") && token.endsWith(q)) {
            String literal = token.substring(1, token.length() - 1);
            return q + this.encodeForJSString(literal) + q;
        }
        if (token.matches("[0-9a-zA-Z_$][0-9a-zA-Z_$.]*")) {
            return token;
        }
        return defaultValue;
    }

    public String encodeForHTML(String source) {
        return ESAPI.encoder().encodeForHTML(source);
    }

    public String encodeForHTMLAttr(String source) {
        return ESAPI.encoder().encodeForHTMLAttribute(source);
    }

    public String encodeForXML(String source) {
        return ESAPI.encoder().encodeForXML(source);
    }

    public String encodeForXMLAttr(String source) {
        return ESAPI.encoder().encodeForXMLAttribute(source);
    }

    public String encodeForJSString(String source) {
        return ESAPI.encoder().encodeForJavaScript(source);
    }

    public String filterHTML(String source) {
        return this.xssFilter.filter(ProtectionContext.HTML_HTML_CONTENT, source);
    }

    public XSSAPI getRequestSpecificAPI(SlingHttpServletRequest request) {
        XSSAPIImpl instance = new XSSAPIImpl();
        instance.xssFilter = this.xssFilter;
        instance.resourceResolver = request.getResourceResolver();
        return instance;
    }

    public XSSAPI getResourceResolverSpecificAPI(ResourceResolver resourceResolver) {
        XSSAPIImpl instance = new XSSAPIImpl();
        instance.xssFilter = this.xssFilter;
        instance.resourceResolver = resourceResolver;
        return instance;
    }

    protected void bindXssFilter(XSSFilter xSSFilter) {
        this.xssFilter = xSSFilter;
    }

    protected void unbindXssFilter(XSSFilter xSSFilter) {
        if (this.xssFilter == xSSFilter) {
            this.xssFilter = null;
        }
    }
}

