/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.xss.impl;

import com.adobe.granite.xss.ProtectionContext;
import com.adobe.granite.xss.XSSFilter;
import com.adobe.granite.xss.impl.HtmlToHtmlContentContext;
import com.adobe.granite.xss.impl.PlainTextToHtmlContentContext;
import com.adobe.granite.xss.impl.PolicyHandler;
import com.adobe.granite.xss.impl.XSSFilterRule;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(immediate=true)
@Service(value={EventHandler.class, XSSFilter.class})
@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/*", "org/apache/sling/api/resource/ResourceProvider/*"})
public class XSSFilterImpl
implements XSSFilter,
EventHandler {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private final XSSFilterRule htmlHtmlContext = new HtmlToHtmlContentContext();
    private final XSSFilterRule plainHtmlContext = new PlainTextToHtmlContentContext();
    private Set<String> checkPaths = new HashSet<String>();
    private Map<String, PolicyHandler> policies = new ConcurrentHashMap<String, PolicyHandler>();
    private static final int DEFAULT_POLICY_CACHE_SIZE = 128;

    private void updateCheckPaths(String policyPath) {
        HashSet<String> newCheckPaths = new HashSet<String>(this.checkPaths);
        ResourceResolver resolver = null;
        try {
            resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            for (String path : resolver.getSearchPath()) {
                newCheckPaths.add(path + policyPath);
                newCheckPaths.add(path + policyPath + "/jcr:content");
            }
            this.checkPaths = newCheckPaths;
        }
        catch (LoginException le) {
            throw new RuntimeException("Unable to get administrative login.", le);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Activate
    protected void activate() {
        this.getPolicyHandler(null);
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        boolean reload = false;
        for (String checkPath : this.checkPaths) {
            if (!path.equals(checkPath)) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.policies.clear();
        }
    }

    private XSSFilterRule getFilterRule(ProtectionContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context == ProtectionContext.HTML_HTML_CONTENT) {
            return this.htmlHtmlContext;
        }
        return this.plainHtmlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyHandler getPolicyHandler(String policyPath) {
        String policyName = policyPath == null ? "cq/xssprotection/config.xml" : policyPath;
        PolicyHandler handler = this.policies.get(policyName);
        if (handler == null) {
            XSSFilterImpl xSSFilterImpl = this;
            synchronized (xSSFilterImpl) {
                try {
                    handler = new PolicyHandler(this.resourceResolverFactory, policyName);
                    if (this.policies.size() < 128) {
                        this.policies.put(policyName, handler);
                        this.updateCheckPaths(policyName);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load policy " + policyName, e);
                }
            }
        }
        return handler;
    }

    public boolean check(ProtectionContext context, String src) {
        return this.check(context, src, null);
    }

    public boolean check(ProtectionContext context, String src, String policy) {
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = ctx.supportsPolicy() ? this.getPolicyHandler(policy) : null;
        return ctx.check(handler, src);
    }

    public String filter(String src) {
        return this.filter(XSSFilter.DEFAULT_CONTEXT, src);
    }

    public String filter(ProtectionContext context, String src) {
        return this.filter(context, src, null);
    }

    public String filter(ProtectionContext context, String src, String policy) {
        if (src == null) {
            return "";
        }
        XSSFilterRule ctx = this.getFilterRule(context);
        PolicyHandler handler = ctx.supportsPolicy() ? this.getPolicyHandler(policy) : null;
        return ctx.filter(handler, src);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

