/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.DefaultEncoder;

public class DefaultRandomizer
implements Randomizer {
    private static volatile Randomizer singletonInstance;
    private SecureRandom secureRandom = null;
    private final Logger logger = ESAPI.getLogger("Randomizer");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Randomizer getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultRandomizer> clazz = DefaultRandomizer.class;
        synchronized (DefaultRandomizer.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultRandomizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultRandomizer() {
        String algorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        try {
            this.secureRandom = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            new EncryptionException("Error creating randomizer", "Can't find random algorithm " + algorithm, e);
        }
    }

    public String getRandomString(int length, char[] characterSet) {
        StringBuilder sb = new StringBuilder();
        for (int loop = 0; loop < length; ++loop) {
            int index = this.secureRandom.nextInt(characterSet.length);
            sb.append(characterSet[index]);
        }
        String nonce = sb.toString();
        return nonce;
    }

    public boolean getRandomBoolean() {
        return this.secureRandom.nextBoolean();
    }

    public int getRandomInteger(int min, int max) {
        return this.secureRandom.nextInt(max - min) + min;
    }

    public long getRandomLong() {
        return this.secureRandom.nextLong();
    }

    public float getRandomReal(float min, float max) {
        float factor = max - min;
        return this.secureRandom.nextFloat() * factor + min;
    }

    public String getRandomFilename(String extension) {
        String fn = this.getRandomString(12, DefaultEncoder.CHAR_ALPHANUMERICS) + "." + extension;
        this.logger.debug(Logger.SECURITY_SUCCESS, "Generated new random filename: " + fn);
        return fn;
    }

    public String getRandomGUID() throws EncryptionException {
        return UUID.randomUUID().toString();
    }

    public byte[] getRandomBytes(int n) {
        byte[] result = new byte[n];
        this.secureRandom.nextBytes(result);
        return result;
    }
}

