/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import android.util.Log;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.AnalyticsCore;
import com.adobe.marketing.mobile.AnalyticsModuleDetails;
import com.adobe.marketing.mobile.Core;
import com.adobe.marketing.mobile.InvalidInitException;
import com.adobe.marketing.mobile.MobileCore;

public class Analytics {
    private static final String TAG = Analytics.class.getSimpleName();
    private static final String OPERATING_SYSTEM = "AND";
    private static final String EXTENSION_VERSION = "1.2.10";
    private static AnalyticsCore analyticsCore;

    private Analytics() {
    }

    public static void registerExtension() throws InvalidInitException {
        Core core = MobileCore.getCore();
        if (core == null) {
            throw new InvalidInitException();
        }
        try {
            String analyticsVersion = Analytics.getVersionString(MobileCore.extensionVersion(), EXTENSION_VERSION);
            analyticsCore = new AnalyticsCore(core.eventHub, new AnalyticsModuleDetails(), analyticsVersion);
        }
        catch (Exception e) {
            throw new InvalidInitException();
        }
    }

    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void getTrackingIdentifier(AdobeCallback<String> callback) {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            Analytics.returnExtensionNotInitializedError(callback);
            return;
        }
        analyticsCore.getTrackingIdentifier(callback);
    }

    public static void getQueueSize(AdobeCallback<Long> callback) {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            Analytics.returnExtensionNotInitializedError(callback);
            return;
        }
        analyticsCore.getQueueSize(callback);
    }

    public static void clearQueue() {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            return;
        }
        analyticsCore.clearQueue();
    }

    public static void sendQueuedHits() {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            return;
        }
        analyticsCore.sendQueuedHits();
    }

    public static void getVisitorIdentifier(AdobeCallback<String> callback) {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            Analytics.returnExtensionNotInitializedError(callback);
            return;
        }
        analyticsCore.getVisitorIdentifier(callback);
    }

    public static void setVisitorIdentifier(String visitorID) {
        if (analyticsCore == null) {
            Log.e((String)TAG, (String)"Could not initialize Adobe Analytics (Is Adobe Core extension enabled?)");
            return;
        }
        analyticsCore.updateVisitorIdentifier(visitorID);
    }

    private static void returnExtensionNotInitializedError(AdobeCallback<?> callback) {
        AdobeCallbackWithError adobeCallbackWithError;
        if (callback == null) {
            return;
        }
        AdobeCallbackWithError adobeCallbackWithError2 = adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        if (adobeCallbackWithError != null) {
            adobeCallbackWithError.fail(AdobeError.EXTENSION_NOT_INITIALIZED);
        }
    }

    static String getVersionString(String mobileCoreVersion, String analyticsVersion) {
        String coreVersion = mobileCoreVersion;
        String wrapperType = "N";
        String[] mobileCoreVersionInfo = coreVersion.split("-");
        if (mobileCoreVersionInfo.length == 2) {
            coreVersion = mobileCoreVersionInfo[0];
            wrapperType = mobileCoreVersionInfo[1];
        }
        String mobileCoreFormattedVersion = Analytics.getFormattedVersion(coreVersion);
        String analyticsFormattedVersion = Analytics.getFormattedVersion(analyticsVersion);
        return OPERATING_SYSTEM + wrapperType + analyticsFormattedVersion + mobileCoreFormattedVersion;
    }

    static String getFormattedVersion(String versionString) {
        String formattedVersionString = "000000";
        String[] versionInfo = versionString.split("\\.");
        if (versionInfo.length == 3) {
            String major = versionInfo[0].length() == 1 ? "0" + versionInfo[0] : versionInfo[0];
            String minor = versionInfo[1].length() == 1 ? "0" + versionInfo[1] : versionInfo[1];
            String build = versionInfo[2].length() == 1 ? "0" + versionInfo[2] : versionInfo[2];
            formattedVersionString = major + minor + build;
        }
        return formattedVersionString;
    }

    static void resetAnalyticsCore() {
        analyticsCore = null;
    }
}

