/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AnalyticsExtension;
import com.adobe.marketing.mobile.AnalyticsVersionProvider;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.EventHub;
import com.adobe.marketing.mobile.EventSource;
import com.adobe.marketing.mobile.EventType;
import com.adobe.marketing.mobile.InvalidModuleException;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.Module;
import com.adobe.marketing.mobile.ModuleDetails;

class AnalyticsCore {
    private static final String LOG_TAG = AnalyticsCore.class.getSimpleName();
    EventHub eventHub;

    AnalyticsCore(EventHub eventHub, ModuleDetails moduleDetails, String version) {
        this(eventHub, moduleDetails, true, version);
    }

    AnalyticsCore(EventHub eventHub, ModuleDetails moduleDetails, boolean registerExtension, String version) {
        if (eventHub == null) {
            Log.error((String)LOG_TAG, (String)"AnalyticsCore - Core initialization was unsuccessful (No EventHub instance found!)", (Object[])new Object[0]);
            return;
        }
        this.eventHub = eventHub;
        if (registerExtension) {
            try {
                eventHub.registerModule(AnalyticsExtension.class, moduleDetails);
                Log.debug((String)LOG_TAG, (String)"Registered %s extension", (Object[])new Object[]{AnalyticsExtension.class.getSimpleName()});
            }
            catch (InvalidModuleException e) {
                Log.debug((String)LOG_TAG, (String)"AnalyticsCore - Failed to register %s module (%s)", (Object[])new Object[]{AnalyticsExtension.class.getSimpleName(), e});
            }
        }
        Log.debug((String)LOG_TAG, (String)"Core initialization was successful", (Object[])new Object[0]);
        AnalyticsVersionProvider.setVersion(version);
    }

    void getTrackingIdentifier(final AdobeCallback<String> callback) {
        if (callback == null) {
            return;
        }
        AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        Event analyticsReqEvent = new Event.Builder("GetTrackingIdentifier", EventType.ANALYTICS, EventSource.REQUEST_IDENTITY).build();
        this.eventHub.registerOneTimeListener(analyticsReqEvent.getResponsePairID(), new Module.OneTimeListenerBlock(){

            public void call(Event e) {
                EventData eventData = e.getData();
                callback.call(eventData != null ? eventData.optString("aid", null) : null);
            }
        }, adobeCallbackWithError);
        this.eventHub.dispatch(analyticsReqEvent);
        Log.debug((String)LOG_TAG, (String)"getTrackingIdentifier - Get tracking identifier request event was sent", (Object[])new Object[0]);
    }

    void getQueueSize(final AdobeCallback<Long> callback) {
        if (callback == null) {
            return;
        }
        AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        Event analyticsReqEvent = new Event.Builder("GetQueueSize", EventType.ANALYTICS, EventSource.REQUEST_CONTENT).setData(new EventData().putBoolean("getqueuesize", true)).build();
        this.eventHub.registerOneTimeListener(analyticsReqEvent.getResponsePairID(), new Module.OneTimeListenerBlock(){

            public void call(Event e) {
                EventData eventData = e.getData();
                long queueSize = 0L;
                if (eventData != null) {
                    queueSize = eventData.optLong("queuesize", 0L);
                }
                callback.call((Object)queueSize);
            }
        }, adobeCallbackWithError);
        this.eventHub.dispatch(analyticsReqEvent);
        Log.debug((String)LOG_TAG, (String)"getQueueSize - Get hits queue size request event was sent", (Object[])new Object[0]);
    }

    void clearQueue() {
        this.eventHub.dispatch(new Event.Builder("ClearHitsQueue", EventType.ANALYTICS, EventSource.REQUEST_CONTENT).setData(new EventData().putBoolean("clearhitsqueue", true)).build());
        Log.debug((String)LOG_TAG, (String)"clearQueue - Clear hits queue event was sent", (Object[])new Object[0]);
    }

    void sendQueuedHits() {
        this.eventHub.dispatch(new Event.Builder("ForceKickHits", EventType.ANALYTICS, EventSource.REQUEST_CONTENT).setData(new EventData().putBoolean("forcekick", true)).build());
        Log.debug((String)LOG_TAG, (String)"sendQueuedHits - Kick all hits event was sent", (Object[])new Object[0]);
    }

    void updateVisitorIdentifier(String vid) {
        this.eventHub.dispatch(new Event.Builder("UpdateVisitorIdentifier", EventType.ANALYTICS, EventSource.REQUEST_IDENTITY).setData(new EventData().putString("vid", vid)).build());
    }

    void getVisitorIdentifier(final AdobeCallback<String> callback) {
        if (callback == null) {
            return;
        }
        Event analyticsReqEvent = new Event.Builder("GetVisitorIdentifier", EventType.ANALYTICS, EventSource.REQUEST_IDENTITY).build();
        AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        this.eventHub.registerOneTimeListener(analyticsReqEvent.getResponsePairID(), new Module.OneTimeListenerBlock(){

            public void call(Event e) {
                EventData eventData = e.getData();
                callback.call(eventData != null ? eventData.optString("vid", null) : null);
            }
        }, adobeCallbackWithError);
        this.eventHub.dispatch(analyticsReqEvent);
    }
}

