/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AnalyticsExtension;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.EventHub;
import com.adobe.marketing.mobile.EventSource;
import com.adobe.marketing.mobile.EventType;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.Module;
import com.adobe.marketing.mobile.ModuleEventDispatcher;
import java.util.HashMap;

class AnalyticsDispatcherAnalyticsResponseContent
extends ModuleEventDispatcher<AnalyticsExtension> {
    private static final String LOG_TAG = AnalyticsDispatcherAnalyticsResponseContent.class.getSimpleName();

    AnalyticsDispatcherAnalyticsResponseContent(EventHub hub, AnalyticsExtension module) {
        super(hub, (Module)module);
    }

    void dispatchAnalyticsHitResponse(String serverResponse, HashMap<String, String> headers, String requestEventIdentifier, String hitHost, String hitUrl) {
        EventData data = new EventData();
        data.putString("analyticsserverresponse", serverResponse);
        data.putStringMap("headers", headers);
        data.putString("hitHost", hitHost);
        data.putString("hitUrl", hitUrl);
        if (requestEventIdentifier != null) {
            data.putString("requestEventIdentifier", requestEventIdentifier);
        }
        super.dispatch(new Event.Builder("AnalyticsResponse", EventType.ANALYTICS, EventSource.RESPONSE_CONTENT).setData(data).build());
        Log.trace((String)LOG_TAG, (String)"dispatchAnalyticsHitResponse - Dispatching Analytics hit response event with eventdata: %s", (Object[])new Object[]{data});
    }

    void dispatchQueueSize(long size, String pairID) {
        EventData data = new EventData();
        data.putLong("queuesize", size);
        super.dispatch(new Event.Builder("QueueSizeValue", EventType.ANALYTICS, EventSource.RESPONSE_CONTENT).setPairID(pairID).setData(data).build());
        Log.trace((String)LOG_TAG, (String)"dispatchQueueSize - Dispatching Analytics hit queue size response event with eventdata: %s", (Object[])new Object[]{data});
    }
}

