/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AnalyticsConstants;
import com.adobe.marketing.mobile.AnalyticsDispatcherAnalyticsResponseContent;
import com.adobe.marketing.mobile.AnalyticsDispatcherAnalyticsResponseIdentity;
import com.adobe.marketing.mobile.AnalyticsHitsDatabase;
import com.adobe.marketing.mobile.AnalyticsListenerAcquisitionResponseContent;
import com.adobe.marketing.mobile.AnalyticsListenerAnalyticsRequestContent;
import com.adobe.marketing.mobile.AnalyticsListenerAnalyticsRequestIdentity;
import com.adobe.marketing.mobile.AnalyticsListenerConfigurationResponseContent;
import com.adobe.marketing.mobile.AnalyticsListenerGenericRequestReset;
import com.adobe.marketing.mobile.AnalyticsListenerGenericTrackRequestContent;
import com.adobe.marketing.mobile.AnalyticsListenerHubBooted;
import com.adobe.marketing.mobile.AnalyticsListenerHubSharedState;
import com.adobe.marketing.mobile.AnalyticsListenerLifecycleRequestContent;
import com.adobe.marketing.mobile.AnalyticsListenerLifecycleResponseContent;
import com.adobe.marketing.mobile.AnalyticsListenerRulesEngineResponseContent;
import com.adobe.marketing.mobile.AnalyticsProperties;
import com.adobe.marketing.mobile.AnalyticsRequestSerializer;
import com.adobe.marketing.mobile.AnalyticsState;
import com.adobe.marketing.mobile.AnalyticsUnprocessedEvent;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventData;
import com.adobe.marketing.mobile.EventHub;
import com.adobe.marketing.mobile.EventSource;
import com.adobe.marketing.mobile.EventType;
import com.adobe.marketing.mobile.InternalModule;
import com.adobe.marketing.mobile.LocalStorageService;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.MissingPlatformServicesException;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.PlatformServices;
import com.adobe.marketing.mobile.StringUtils;
import com.adobe.marketing.mobile.UIService;
import com.adobe.marketing.mobile.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

class AnalyticsExtension
extends InternalModule {
    private static final String LOG_TAG = AnalyticsExtension.class.getSimpleName();
    private EventData analyticsSharedData;
    private long mostRecentHitTimestampInSeconds;
    private final List<String> analyticsSoftDependencies;
    private final List<String> analyticsHardDependencies;
    AnalyticsDispatcherAnalyticsResponseContent analyticsResponseDispatcher;
    AnalyticsDispatcherAnalyticsResponseIdentity analyticsIdentityResponseDispatcher;
    AnalyticsHitsDatabase hitDatabase;
    AnalyticsProperties analyticsProperties;
    ConcurrentLinkedQueue<AnalyticsUnprocessedEvent> analyticsUnprocessedEvents;
    AnalyticsRequestSerializer analyticsRequestSerializer;

    AnalyticsExtension(EventHub hub, PlatformServices services) {
        super("com.adobe.module.analytics", hub, services);
        this.registerAnalyticsListeners();
        this.registerAnalyticsDispatchers();
        this.analyticsProperties = new AnalyticsProperties();
        this.analyticsUnprocessedEvents = new ConcurrentLinkedQueue();
        this.analyticsRequestSerializer = new AnalyticsRequestSerializer();
        this.analyticsHardDependencies = new ArrayList<String>();
        this.analyticsHardDependencies.add("com.adobe.module.configuration");
        this.analyticsHardDependencies.add("com.adobe.module.identity");
        this.analyticsSoftDependencies = new ArrayList<String>();
        this.analyticsSoftDependencies.add("com.adobe.module.places");
        this.analyticsSoftDependencies.add("com.adobe.assurance");
        this.analyticsSoftDependencies.add("com.adobe.module.lifecycle");
    }

    private void registerAnalyticsListeners() {
        this.registerListener(EventType.RULES_ENGINE, EventSource.RESPONSE_CONTENT, AnalyticsListenerRulesEngineResponseContent.class);
        this.registerListener(EventType.ANALYTICS, EventSource.REQUEST_CONTENT, AnalyticsListenerAnalyticsRequestContent.class);
        this.registerListener(EventType.ANALYTICS, EventSource.REQUEST_IDENTITY, AnalyticsListenerAnalyticsRequestIdentity.class);
        this.registerListener(EventType.HUB, EventSource.SHARED_STATE, AnalyticsListenerHubSharedState.class);
        this.registerListener(EventType.HUB, EventSource.BOOTED, AnalyticsListenerHubBooted.class);
        this.registerListener(EventType.CONFIGURATION, EventSource.RESPONSE_CONTENT, AnalyticsListenerConfigurationResponseContent.class);
        this.registerListener(EventType.GENERIC_LIFECYLE, EventSource.REQUEST_CONTENT, AnalyticsListenerLifecycleRequestContent.class);
        this.registerListener(EventType.LIFECYCLE, EventSource.RESPONSE_CONTENT, AnalyticsListenerLifecycleResponseContent.class);
        this.registerListener(EventType.ACQUISITION, EventSource.RESPONSE_CONTENT, AnalyticsListenerAcquisitionResponseContent.class);
        this.registerListener(EventType.GENERIC_TRACK, EventSource.REQUEST_CONTENT, AnalyticsListenerGenericTrackRequestContent.class);
        this.registerListener(EventType.GENERIC_IDENTITY, EventSource.REQUEST_RESET, AnalyticsListenerGenericRequestReset.class);
    }

    void registerAnalyticsDispatchers() {
        this.analyticsResponseDispatcher = (AnalyticsDispatcherAnalyticsResponseContent)this.createDispatcher(AnalyticsDispatcherAnalyticsResponseContent.class);
        this.analyticsIdentityResponseDispatcher = (AnalyticsDispatcherAnalyticsResponseIdentity)this.createDispatcher(AnalyticsDispatcherAnalyticsResponseIdentity.class);
    }

    void track(AnalyticsState state, EventData trackEventData, long timestampInSeconds, boolean appendToPlaceHolder, String eventUniqueIdentifier) {
        if (trackEventData == null) {
            Log.debug((String)LOG_TAG, (String)"track - Dropping the Analytics track request, request was null.", (Object[])new Object[0]);
            return;
        }
        if (!state.isAnalyticsConfigured()) {
            Log.warning((String)LOG_TAG, (String)"track - Dropping the Analytics track request, Analytics is not configured.", (Object[])new Object[0]);
            return;
        }
        this.setMostRecentHitTimestampInSeconds(timestampInSeconds);
        if (MobilePrivacyStatus.OPT_OUT == state.getPrivacyStatus()) {
            Log.warning((String)LOG_TAG, (String)"track - Dropping the Analytics track request, privacy status is opted out.", (Object[])new Object[0]);
            return;
        }
        Map<String, String> analyticsData = this.processAnalyticsContextData(state, trackEventData);
        Map<String, String> analyticsVars = this.processAnalyticsVars(state, trackEventData, timestampInSeconds);
        String builtRequest = this.analyticsRequestSerializer.buildRequest(state, analyticsData, analyticsVars);
        AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
        if (analyticsHitsDatabase != null) {
            if (appendToPlaceHolder) {
                analyticsHitsDatabase.updateBackdatedHit(state, builtRequest, timestampInSeconds, eventUniqueIdentifier);
            } else {
                analyticsHitsDatabase.queue(state, builtRequest, timestampInSeconds, this.analyticsProperties.isDatabaseWaiting(), false, eventUniqueIdentifier);
            }
            Log.debug((String)LOG_TAG, (String)"track - Track Request Queued (%s)", (Object[])new Object[]{builtRequest});
        } else {
            Log.warning((String)LOG_TAG, (String)"track - Unable to queue analytic hit. Database Service is unavailable", (Object[])new Object[0]);
        }
    }

    private void setMostRecentHitTimestampInSeconds(long timestampInSeconds) {
        this.mostRecentHitTimestampInSeconds = this.getMostRecentHitTimestampInSeconds();
        if (this.mostRecentHitTimestampInSeconds < timestampInSeconds) {
            this.mostRecentHitTimestampInSeconds = timestampInSeconds;
            LocalStorageService.DataStore dataStore = this.getDataStore();
            if (dataStore != null) {
                dataStore.setLong("mostRecentHitTimestampSeconds", timestampInSeconds);
            } else {
                Log.warning((String)LOG_TAG, (String)"setMostRecentHitTimestampInSeconds - Unable to set most recent hit timestamp in persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
            }
        }
    }

    private long getMostRecentHitTimestampInSeconds() {
        if (this.mostRecentHitTimestampInSeconds <= 0L) {
            LocalStorageService.DataStore dataStore = this.getDataStore();
            if (dataStore != null) {
                this.mostRecentHitTimestampInSeconds = dataStore.getLong("mostRecentHitTimestampSeconds", 0L);
            } else {
                Log.warning((String)LOG_TAG, (String)"getMostRecentHitTimestampInSeconds - Unable to get most recent hit timestamp from persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
            }
        }
        return this.mostRecentHitTimestampInSeconds;
    }

    Map<String, String> processAnalyticsContextData(AnalyticsState state, EventData trackEventData) {
        String requestIdentifier;
        long lifecycleSessionStartTimestamp;
        Map contextData;
        HashMap<String, String> analyticsData = new HashMap<String, String>();
        if (state.getDefaultData() != null) {
            analyticsData.putAll(state.getDefaultData());
        }
        if ((contextData = trackEventData.optStringMap("contextdata", null)) != null) {
            analyticsData.putAll(contextData);
        }
        String actionName = trackEventData.optString("action", null);
        boolean isInternal = trackEventData.optBoolean("trackinternal", false);
        if (!StringUtils.isNullOrEmpty((String)actionName)) {
            analyticsData.put(this.getActionKey(isInternal), actionName);
        }
        if ((lifecycleSessionStartTimestamp = state.getLifecycleSessionStartTimestamp()) > 0L) {
            long maxSessionLengthInSeconds = state.getLifecycleMaxSessionLength();
            long timeSinceLaunchInSeconds = this.getTimeSinceLaunch(lifecycleSessionStartTimestamp);
            if (timeSinceLaunchInSeconds >= 0L && timeSinceLaunchInSeconds <= maxSessionLengthInSeconds) {
                analyticsData.put("a.TimeSinceLaunch", String.valueOf(timeSinceLaunchInSeconds));
            }
        }
        if (state.getPrivacyStatus() == MobilePrivacyStatus.UNKNOWN) {
            analyticsData.put("a.privacy.mode", "unknown");
        }
        if ((requestIdentifier = trackEventData.optString("requestEventIdentifier", null)) != null) {
            analyticsData.put("a.DebugEventIdentifier", requestIdentifier);
        }
        return analyticsData;
    }

    Map<String, String> processAnalyticsVars(AnalyticsState state, EventData trackData, long timestamp) {
        String vid;
        HashMap<String, String> analyticsVars = new HashMap<String, String>();
        String actionName = trackData.optString("action", null);
        String stateName = trackData.optString("state", null);
        if (!StringUtils.isNullOrEmpty((String)actionName)) {
            analyticsVars.put("pe", "lnk_o");
            boolean isInternal = trackData.optBoolean("trackinternal", false);
            analyticsVars.put("pev2", this.getActionPrefix(isInternal) + actionName);
        }
        analyticsVars.put("pageName", state.getApplicationID());
        if (!StringUtils.isNullOrEmpty((String)stateName)) {
            analyticsVars.put("pageName", stateName);
        }
        if (!StringUtils.isNullOrEmpty((String)this.analyticsProperties.getAid())) {
            analyticsVars.put("aid", this.analyticsProperties.getAid());
        }
        if (!StringUtils.isNullOrEmpty((String)(vid = this.analyticsProperties.getVid()))) {
            analyticsVars.put("vid", vid);
        }
        analyticsVars.put("ce", "UTF-8");
        analyticsVars.put("t", AnalyticsProperties.TIMESTAMP_TIMEZONE_OFFSET);
        if (state.isOfflineTrackingEnabled()) {
            analyticsVars.put("ts", Long.toString(timestamp));
        }
        if (state.isVisitorIDServiceEnabled()) {
            analyticsVars.putAll(state.getAnalyticsIdVisitorParameters());
        }
        if (this.getPlatformServices() == null) {
            Log.warning((String)LOG_TAG, (String)"processAnalyticsVars - Unable to access platform services. Platform services is null", (Object[])new Object[0]);
            return null;
        }
        UIService uiService = this.getPlatformServices().getUIService();
        if (uiService != null && uiService.getAppState() == UIService.AppState.BACKGROUND) {
            analyticsVars.put("cp", "background");
        } else {
            analyticsVars.put("cp", "foreground");
        }
        return analyticsVars;
    }

    void updatePrivacyStatus(int eventNumber, AnalyticsState state) {
        if (state.getPrivacyStatus() == MobilePrivacyStatus.OPT_IN) {
            AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
            if (analyticsHitsDatabase != null) {
                analyticsHitsDatabase.kick(state, false);
            } else {
                Log.warning((String)LOG_TAG, (String)"updatePrivacyStatus - Unable to kick the analytics hits. Database Service is unavailable", (Object[])new Object[0]);
            }
        } else if (state.getPrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            this.clearAllHits();
            this.purgeAid();
            this.purgeVid();
            this.createSharedState(eventNumber, new EventData());
        }
    }

    void clearAllHits() {
        this.clearUnprocessedEventQueue();
        AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
        if (analyticsHitsDatabase != null) {
            analyticsHitsDatabase.clearTrackingQueue();
        } else {
            Log.warning((String)LOG_TAG, (String)"clearAllHits - Unable to clear tracking queue. Database Service is unavailable", (Object[])new Object[0]);
        }
    }

    void purgeAid() {
        if (this.analyticsSharedData != null) {
            this.analyticsSharedData.putString("aid", null);
        }
        if (this.analyticsProperties != null) {
            this.analyticsProperties.setAid(null);
        }
        this.updateAIDInLocalStorage(null);
    }

    void purgeVid() {
        if (this.analyticsSharedData != null) {
            this.analyticsSharedData.putString("vid", null);
        }
        if (this.analyticsProperties != null) {
            this.analyticsProperties.setVid(null);
        }
        this.updateVIDInLocalStorage(null);
    }

    void clearUnprocessedEventQueue() {
        for (AnalyticsUnprocessedEvent unprocessedEvent : this.analyticsUnprocessedEvents) {
            Event event = unprocessedEvent.getEvent();
            if (event.getEventType() == EventType.ANALYTICS && event.getEventSource() == EventSource.REQUEST_IDENTITY) {
                this.analyticsIdentityResponseDispatcher.dispatch(null, null, event.getResponsePairID());
            }
            if (event.getEventType() != EventType.ANALYTICS || event.getEventSource() != EventSource.REQUEST_CONTENT) continue;
            this.analyticsResponseDispatcher.dispatchQueueSize(0L, event.getResponsePairID());
        }
        this.analyticsUnprocessedEvents.clear();
    }

    void getTrackingQueueSize(String pairID) {
        long databaseQueueSize = 0L;
        AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
        if (analyticsHitsDatabase != null) {
            databaseQueueSize = analyticsHitsDatabase.getTrackingQueueSize();
        } else {
            Log.warning((String)LOG_TAG, (String)"getTrackingQueueSize - Database queueSize is 0. Database Service is unavailable", (Object[])new Object[0]);
        }
        this.analyticsResponseDispatcher.dispatchQueueSize(databaseQueueSize + (long)this.analyticsUnprocessedEvents.size(), pairID);
    }

    void handleAnalyticsIdentityRequest(String pairID, int eventNumber) {
        LocalStorageService.DataStore dataStore;
        if (this.analyticsSharedData == null) {
            this.analyticsSharedData = new EventData();
        }
        if ((dataStore = this.getDataStore()) != null) {
            this.analyticsProperties.setAid(dataStore.getString("ADOBEMOBILE_STOREDDEFAULTS_AID", null));
            this.analyticsProperties.setVid(dataStore.getString("ADOBEMOBILE_STOREDDEFAULTS_VISITOR_IDENTIFIER", null));
        } else {
            Log.warning((String)LOG_TAG, (String)"handleAnalyticsIdentityRequest - Unable to get AID from persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
        }
        this.analyticsSharedData.putString("aid", this.analyticsProperties.getAid());
        this.analyticsSharedData.putString("vid", this.analyticsProperties.getVid());
        this.createSharedState(eventNumber, this.analyticsSharedData);
        Log.trace((String)LOG_TAG, (String)"handleAnalyticsIdentityRequest - New analytics response identity dispatched, with aid = %s, vid = %s", (Object[])new Object[]{this.analyticsProperties.getAid(), this.analyticsProperties.getVid()});
        this.analyticsIdentityResponseDispatcher.dispatch(this.analyticsProperties.getAid(), this.analyticsProperties.getVid(), pairID);
    }

    void handleVisitorIdentifierRequest(AnalyticsState state, String vid, String pairID, int eventNumber) {
        if (state.getPrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            Log.trace((String)LOG_TAG, (String)"handleVisitorIdentifierRequest - Returning null identifiers as privacy status is opt-out.", (Object[])new Object[0]);
            this.analyticsIdentityResponseDispatcher.dispatch(null, null, pairID);
            return;
        }
        LocalStorageService.DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            Log.error((String)LOG_TAG, (String)"handleVisitorIdentifierRequest - Unable to update visitor identifier in persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
            return;
        }
        this.updateVIDInLocalStorage(vid);
        String aid = null;
        if (this.analyticsProperties != null) {
            this.analyticsProperties.setVid(vid);
            aid = this.analyticsProperties.getAid();
        }
        if (this.analyticsSharedData != null) {
            this.analyticsSharedData.putString("aid", aid);
            this.analyticsSharedData.putString("vid", vid);
        }
        this.createSharedState(eventNumber, this.analyticsSharedData);
        this.analyticsIdentityResponseDispatcher.dispatch(aid, vid, pairID);
    }

    private void updateAIDInLocalStorage(String id) {
        LocalStorageService.DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            if (!StringUtils.isNullOrEmpty((String)id)) {
                dataStore.setString("ADOBEMOBILE_STOREDDEFAULTS_AID", id);
            } else {
                dataStore.remove("ADOBEMOBILE_STOREDDEFAULTS_AID");
            }
        } else {
            Log.warning((String)LOG_TAG, (String)"updateAIDInLocalStorage - Unable to update AID in persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
        }
    }

    private void updateVIDInLocalStorage(String vid) {
        LocalStorageService.DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            if (!StringUtils.isNullOrEmpty((String)vid)) {
                dataStore.setString("ADOBEMOBILE_STOREDDEFAULTS_VISITOR_IDENTIFIER", vid);
            } else {
                dataStore.remove("ADOBEMOBILE_STOREDDEFAULTS_VISITOR_IDENTIFIER");
            }
        } else {
            Log.warning((String)LOG_TAG, (String)"updateVIDInLocalStorage - Unable to update VID in persistence. LocalStorage Service not initialized.", (Object[])new Object[0]);
        }
    }

    void putEvent(Event event, List<String> hardDependencies, List<String> softDependencies) {
        if (event != null && event.getData() != null) {
            this.analyticsUnprocessedEvents.add(new AnalyticsUnprocessedEvent(event, hardDependencies, softDependencies));
        }
    }

    void processEvents() {
        AnalyticsUnprocessedEvent event;
        Map<String, EventData> sharedStates;
        while (!this.analyticsUnprocessedEvents.isEmpty() && (sharedStates = this.getSharedState(event = this.analyticsUnprocessedEvents.peek())) != null) {
            this.process(event.getEvent(), sharedStates);
            this.analyticsUnprocessedEvents.poll();
        }
    }

    private Map<String, EventData> getSharedState(AnalyticsUnprocessedEvent event) {
        EventData sharedData;
        HashMap<String, EventData> sharedStates = new HashMap<String, EventData>();
        for (String state : event.getHardStateDependencies()) {
            sharedData = this.getSharedEventState(state, event.getEvent());
            if (!this.hasSharedEventState(state)) {
                Log.debug((String)LOG_TAG, (String)"getSharedState - Shared State for %s couldn't be retrieved at the time, will retry later. If this message persists, please make sure you have registered and configured the %s extension properly based on the documentation.", (Object[])new Object[]{state, state});
                return null;
            }
            if (sharedData == EventHub.SHARED_STATE_PENDING) {
                Log.debug((String)LOG_TAG, (String)"getSharedState - Shared State for %s couldn't be retrieved at the time of process while it is pending, will retry later.", (Object[])new Object[]{state});
                return null;
            }
            sharedStates.put(state, new EventData(sharedData));
        }
        for (String state : event.getSoftStateDependencies()) {
            sharedData = this.getSharedEventState(state, event.getEvent());
            if (sharedData == null) continue;
            sharedStates.put(state, new EventData(sharedData));
        }
        return sharedStates;
    }

    void process(Event event, Map<String, EventData> sharedDependencies) {
        if (event == null || event.getData() == null) {
            Log.debug((String)LOG_TAG, (String)"process - Failed to process this event; invalid event or null data", (Object[])new Object[0]);
            return;
        }
        AnalyticsState state = new AnalyticsState(sharedDependencies);
        EventData eventData = event.getData();
        EventSource eventSource = event.getEventSource();
        EventType eventType = event.getEventType();
        if ((eventType == EventType.ANALYTICS || eventType == EventType.GENERIC_TRACK) && eventSource == EventSource.REQUEST_CONTENT) {
            if (eventData.containsKey("state") || eventData.containsKey("action") || eventData.containsKey("contextdata")) {
                this.track(state, eventData, event.getTimestampInSeconds(), false, event.getUniqueIdentifier());
            }
            if (eventData.containsKey("forcekick")) {
                this.forceKickEventsFromDB(state);
            }
        } else if (eventType == EventType.LIFECYCLE && eventSource == EventSource.RESPONSE_CONTENT) {
            this.analyticsProperties.setLifecyclePreviousSessionPauseTimestamp(eventData.optLong("previoussessionpausetimestampmillis", 0L));
            this.trackLifecycle(state, event);
        } else if (eventType == EventType.ACQUISITION && eventSource == EventSource.RESPONSE_CONTENT) {
            this.trackAcquisition(state, event);
        } else if (eventType == EventType.HUB && eventSource == EventSource.BOOTED || eventType == EventType.ANALYTICS && eventSource == EventSource.REQUEST_IDENTITY) {
            if (eventData.containsKey("vid")) {
                String vid = eventData.optString("vid", "");
                String pairId = event.getResponsePairID();
                int eventNumber = event.getEventNumber();
                this.handleVisitorIdentifierRequest(state, vid, pairId, eventNumber);
            } else {
                this.handleAnalyticsIdentityRequest(event.getResponsePairID(), event.getEventNumber());
            }
        } else if (eventType == EventType.RULES_ENGINE && eventSource == EventSource.RESPONSE_CONTENT) {
            Map triggeredConsequence = eventData.optVariantMap("triggeredconsequence", null);
            if (triggeredConsequence != null) {
                EventData convertedEventData = new EventData(((Variant)triggeredConsequence.get("detail")).optVariantMap(new HashMap()));
                this.track(state, convertedEventData, event.getTimestampInSeconds(), false, event.getUniqueIdentifier());
            } else {
                Log.debug((String)LOG_TAG, (String)"process - Triggered consequence is null, ignoring", (Object[])new Object[0]);
            }
        } else if (eventType == EventType.GENERIC_LIFECYLE && eventSource == EventSource.REQUEST_CONTENT) {
            this.processLifecycleRequest(state, event);
        } else if (eventType == EventType.GENERIC_IDENTITY && eventSource == EventSource.REQUEST_RESET) {
            this.processGenericResetEvent(event);
        } else if (eventType == EventType.CONFIGURATION && eventSource == EventSource.RESPONSE_CONTENT) {
            this.updatePrivacyStatus(event.getEventNumber(), state);
        }
    }

    void trackAcquisition(AnalyticsState state, Event event) {
        if (state == null) {
            Log.trace((String)LOG_TAG, (String)"trackAcquisition - Failed to track acquisition event (invalid state)", (Object[])new Object[0]);
            return;
        }
        Map acquisitionContextData = event.getData().optStringMap("contextdata", new HashMap());
        if (this.analyticsProperties.getReferrerTimerState().isTimerRunning()) {
            this.analyticsProperties.getReferrerTimerState().cancel();
            AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
            if (analyticsHitsDatabase != null) {
                analyticsHitsDatabase.kickWithAdditionalData(state, acquisitionContextData);
            } else {
                Log.warning((String)LOG_TAG, (String)"trackAcquisition - Unable to kick analytic hit with referrer data. Database Service is unavailable", (Object[])new Object[0]);
            }
        } else {
            this.analyticsProperties.getReferrerTimerState().cancel();
            EventData acquisitionData = new EventData().putString("action", "AdobeLink").putStringMap("contextdata", acquisitionContextData).putBoolean("trackinternal", true);
            this.track(state, acquisitionData, event.getTimestampInSeconds(), false, event.getUniqueIdentifier());
        }
    }

    void trackLifecycle(AnalyticsState state, Event event) {
        if (state == null) {
            Log.trace((String)LOG_TAG, (String)"trackLifecycle - Failed to track lifecycle event (invalid state)", (Object[])new Object[0]);
            return;
        }
        Map eventLifecycleContextData = event.getData().optStringMap("lifecyclecontextdata", null);
        if (eventLifecycleContextData == null || eventLifecycleContextData.isEmpty()) {
            Log.trace((String)LOG_TAG, (String)"trackLifecycle - Failed to track lifecycle event (context data was null or empty)", (Object[])new Object[0]);
            return;
        }
        HashMap tempLifecycleContextData = new HashMap(eventLifecycleContextData);
        HashMap<String, String> lifecycleContextData = new HashMap<String, String>();
        String previousOsVersion = (String)tempLifecycleContextData.remove("previousosversion");
        String previousAppIdVersion = (String)tempLifecycleContextData.remove("previousappid");
        for (Map.Entry<String, String> kvp : AnalyticsConstants.MAP_TO_CONTEXT_DATA_KEYS.entrySet()) {
            String value = (String)tempLifecycleContextData.get(kvp.getKey());
            if (StringUtils.isNullOrEmpty((String)value)) continue;
            lifecycleContextData.put(kvp.getValue(), value);
            tempLifecycleContextData.remove(kvp.getKey());
        }
        lifecycleContextData.putAll(tempLifecycleContextData);
        if (lifecycleContextData.containsKey("a.InstallEvent")) {
            this.waitForAcquisitionData(state, TimeUnit.SECONDS.toMillis(state.getReferrerTimeout()));
        } else if (lifecycleContextData.containsKey("a.LaunchEvent")) {
            this.waitForAcquisitionData(state, 500L);
        }
        if (state.isBackdateSessionInfoEnabled() && state.isOfflineTrackingEnabled()) {
            if (lifecycleContextData.containsKey("a.CrashEvent")) {
                lifecycleContextData.remove("a.CrashEvent");
                this.backdateLifecycleCrash(state, previousOsVersion, previousAppIdVersion, event.getUniqueIdentifier());
            }
            if (lifecycleContextData.containsKey("a.PrevSessionLength")) {
                String previousSessionLength = (String)lifecycleContextData.remove("a.PrevSessionLength");
                this.backdateLifecycleSessionInfo(state, previousSessionLength, previousOsVersion, previousAppIdVersion, event.getUniqueIdentifier());
            }
        }
        AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
        if (this.analyticsProperties.getLifecycleTimerState().isTimerRunning() && analyticsHitsDatabase != null && analyticsHitsDatabase.isHitWaiting()) {
            this.analyticsProperties.getLifecycleTimerState().cancel();
            analyticsHitsDatabase.kickWithAdditionalData(state, lifecycleContextData);
        } else {
            this.analyticsProperties.getLifecycleTimerState().cancel();
            EventData lifecycleData = new EventData().putString("action", "Lifecycle").putStringMap("contextdata", lifecycleContextData).putBoolean("trackinternal", true);
            this.track(state, lifecycleData, event.getTimestampInSeconds(), false, event.getUniqueIdentifier());
        }
    }

    private void backdateLifecycleCrash(AnalyticsState state, String previousOSVersion, String previousAppIdVersion, String eventUniqueIdentifier) {
        HashMap<String, String> crashContextData = new HashMap<String, String>();
        crashContextData.put("a.CrashEvent", "CrashEvent");
        if (!StringUtils.isNullOrEmpty((String)previousOSVersion)) {
            crashContextData.put("a.OSVersion", previousOSVersion);
        }
        if (!StringUtils.isNullOrEmpty((String)previousAppIdVersion)) {
            crashContextData.put("a.AppID", previousAppIdVersion);
        }
        EventData lifecycleSessionData = new EventData().putString("action", "Crash").putStringMap("contextdata", crashContextData).putBoolean("trackinternal", true);
        this.track(state, lifecycleSessionData, this.getMostRecentHitTimestampInSeconds() + 1L, true, eventUniqueIdentifier);
    }

    private void backdateLifecycleSessionInfo(AnalyticsState state, String previousSessionLength, String previousOSVersion, String previousAppIdVersion, String eventUniqueIdentifier) {
        HashMap<String, String> sessionContextData = new HashMap<String, String>();
        if (previousSessionLength != null) {
            sessionContextData.put("a.PrevSessionLength", previousSessionLength);
        }
        if (!StringUtils.isNullOrEmpty((String)previousOSVersion)) {
            sessionContextData.put("a.OSVersion", previousOSVersion);
        }
        if (!StringUtils.isNullOrEmpty((String)previousAppIdVersion)) {
            sessionContextData.put("a.AppID", previousAppIdVersion);
        }
        EventData lifecycleSessionData = new EventData().putString("action", "SessionInfo").putStringMap("contextdata", sessionContextData).putBoolean("trackinternal", true);
        long backdateTimestamp = Math.max(this.getMostRecentHitTimestampInSeconds(), this.analyticsProperties.getLifecyclePreviousSessionPauseTimestamp());
        this.track(state, lifecycleSessionData, backdateTimestamp + 1L, true, eventUniqueIdentifier);
    }

    void handleSharedStateUpdateEvent(String stateOwner) {
        if (this.analyticsHardDependencies.contains(stateOwner)) {
            this.processEvents();
        }
    }

    void handleConfigurationUpdateEvent(Event event) {
        if (event == null) {
            return;
        }
        EventData eventData = event.getData();
        if (eventData == null) {
            return;
        }
        this.putEvent(event, this.analyticsHardDependencies, this.analyticsSoftDependencies);
        this.processEvents();
    }

    void handleGenericResetEvent(Event event) {
        Log.debug((String)LOG_TAG, (String)"handleGenericResetEvent - queuing resetIdentities event.", (Object[])new Object[0]);
        this.analyticsProperties.setLastResetIdentitiesTimestamp(event.getTimestampInSeconds());
        this.putEvent(event, null, null);
        this.processEvents();
    }

    void processGenericResetEvent(Event event) {
        Log.debug((String)LOG_TAG, (String)"processGenericResetEvent - Resetting all identifiers.", (Object[])new Object[0]);
        this.clearAllHits();
        this.purgeAid();
        this.purgeVid();
        this.createSharedState(event.getEventNumber(), new EventData());
    }

    void handleAcquisitionResponseEvent(Event acquisitionEvent) {
        if (this.analyticsProperties.getReferrerTimerState().isTimerRunning()) {
            Log.debug((String)LOG_TAG, (String)"handleAcquisitionResponseEvent - Acquisition response received with referrer data.", (Object[])new Object[0]);
            this.analyticsProperties.getReferrerTimerState().cancel();
            AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
            if (analyticsHitsDatabase != null) {
                analyticsHitsDatabase.kickWithAdditionalData(null, acquisitionEvent.getData() != null ? acquisitionEvent.getData().optStringMap("contextdata", null) : null);
            } else {
                Log.warning((String)LOG_TAG, (String)"handleAcquisitionResponseEvent - Unable to kick analytics hit with referrer data. Database Service is unavailable", (Object[])new Object[0]);
            }
        } else {
            this.putEvent(acquisitionEvent, this.analyticsHardDependencies, this.analyticsSoftDependencies);
            this.processEvents();
        }
    }

    void handleAnalyticsRequestEvent(Event event) {
        EventData data = event.getData();
        if (data.containsKey("clearhitsqueue")) {
            this.clearAllHits();
        } else if (data.containsKey("getqueuesize")) {
            this.getTrackingQueueSize(event.getResponsePairID());
        } else if (data.containsKey("forcekick")) {
            this.putEvent(event, this.analyticsHardDependencies, this.analyticsSoftDependencies);
            this.processEvents();
        } else if (data.containsKey("action") || data.containsKey("state") || data.containsKey("contextdata")) {
            this.putEvent(event, this.analyticsHardDependencies, this.analyticsSoftDependencies);
            this.processEvents();
        }
    }

    void processAnalyticsIDRequest(Event event) {
        this.putEvent(event, this.analyticsHardDependencies, null);
        this.processEvents();
    }

    void handleLifecycleResponseEvent(Event event) {
        this.putEvent(event, this.analyticsHardDependencies, this.analyticsSoftDependencies);
        this.processEvents();
    }

    void handleLifecycleRequestEvent(Event event) {
        this.putEvent(event, this.analyticsHardDependencies, null);
        this.processEvents();
    }

    void processLifecycleRequest(AnalyticsState state, Event event) {
        if (state == null) {
            Log.debug((String)LOG_TAG, (String)"processLifecycleRequest - Failed to track lifecycle event (invalid state)", (Object[])new Object[0]);
            return;
        }
        String lifecycleAction = event.getData().optString("action", null);
        if ("start".equals(lifecycleAction)) {
            boolean shouldIgnoreStart;
            long timestampDiff = event.getTimestamp() - this.analyticsProperties.getLifecyclePrevoiusPauseEventTimestamp();
            int timeout = Math.min(1000, state.getSessionTimeout());
            boolean bl = shouldIgnoreStart = this.analyticsProperties.getLifecyclePrevoiusPauseEventTimestamp() != 0L && timestampDiff < (long)timeout;
            if (this.analyticsProperties.getLifecycleTimerState().isTimerRunning() || shouldIgnoreStart) {
                return;
            }
            this.waitForLifecycleData();
            AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
            if (analyticsHitsDatabase != null) {
                analyticsHitsDatabase.resetIsWaitingFlag();
                analyticsHitsDatabase.queue(null, "", 0L, false, true, event.getUniqueIdentifier());
            }
        }
        if ("pause".equals(lifecycleAction)) {
            this.analyticsProperties.getLifecycleTimerState().cancel();
            this.analyticsProperties.getReferrerTimerState().cancel();
            this.analyticsProperties.setLifecyclePrevoiusPauseEventTimestamp(event.getTimestamp());
        }
    }

    void handleHubBootedEvent(Event event) {
        this.putEvent(event, this.analyticsHardDependencies, new ArrayList<String>());
        this.processEvents();
    }

    void handleAnalyticsConsequenceEvent(Event event) {
        if (event == null) {
            Log.debug((String)LOG_TAG, (String)"Ignoring analytics rules consequence, event was null.", (Object[])new Object[0]);
            return;
        }
        this.putEvent(event, this.analyticsHardDependencies, this.analyticsSoftDependencies);
        this.processEvents();
    }

    private LocalStorageService.DataStore getDataStore() {
        PlatformServices platformServices = this.getPlatformServices();
        if (platformServices == null) {
            Log.warning((String)LOG_TAG, (String)"getDataStore - Unable to access platform services", (Object[])new Object[0]);
            return null;
        }
        LocalStorageService localStorageService = platformServices.getLocalStorageService();
        return localStorageService == null ? null : localStorageService.getDataStore("AnalyticsDataStorage");
    }

    private String getActionKey(boolean isInternalAction) {
        return isInternalAction ? "a.internalaction" : "a.action";
    }

    private String getActionPrefix(boolean isInternalAction) {
        return isInternalAction ? "ADBINTERNAL:" : "AMACTION:";
    }

    private void forceKickEventsFromDB(AnalyticsState state) {
        AnalyticsHitsDatabase analyticsHitsDatabase = this.getHitDatabase();
        if (analyticsHitsDatabase != null) {
            analyticsHitsDatabase.forceKick(state);
        } else {
            Log.warning((String)LOG_TAG, (String)"forceKickEventsFromDB - Unable to force kick analytic hits. Database Service is unavailable", (Object[])new Object[0]);
        }
    }

    private AnalyticsHitsDatabase getHitDatabase() {
        try {
            if (this.hitDatabase == null) {
                this.hitDatabase = new AnalyticsHitsDatabase(this.getPlatformServices(), this.analyticsProperties, this.analyticsResponseDispatcher);
            }
        }
        catch (MissingPlatformServicesException exp) {
            Log.error((String)LOG_TAG, (String)"getHitDatabase - Database service not initialized %s", (Object[])new Object[]{exp});
        }
        return this.hitDatabase;
    }

    private long getTimeSinceLaunch(long lifecycleSessionStartTimestampInSeconds) {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - lifecycleSessionStartTimestampInSeconds;
    }

    private void waitForLifecycleData() {
        this.analyticsProperties.getLifecycleTimerState().startTimer(1000L, (AdobeCallback)new AdobeCallback<Boolean>(){

            public void call(Boolean value) {
                AnalyticsExtension.this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Log.warning((String)LOG_TAG, (String)"waitForLifecycleData - Lifecycle timeout has expired without Lifecycle data", (Object[])new Object[0]);
                        AnalyticsHitsDatabase analyticsHitsDatabase = AnalyticsExtension.this.getHitDatabase();
                        if (analyticsHitsDatabase != null) {
                            analyticsHitsDatabase.kick(null, false);
                        }
                    }
                });
            }
        });
    }

    private void waitForAcquisitionData(final AnalyticsState state, long timeout) {
        this.analyticsProperties.getReferrerTimerState().startTimer(timeout, (AdobeCallback)new AdobeCallback<Boolean>(){

            public void call(Boolean value) {
                AnalyticsExtension.this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Log.warning((String)LOG_TAG, (String)"waitForAcquisitionData - Referrer timeout has expired without referrer data", (Object[])new Object[0]);
                        AnalyticsHitsDatabase analyticsHitsDatabase = AnalyticsExtension.this.getHitDatabase();
                        if (analyticsHitsDatabase != null) {
                            analyticsHitsDatabase.kick(state, false);
                        }
                    }
                });
            }
        });
    }
}

