/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AbstractHitSchema;
import com.adobe.marketing.mobile.AnalyticsHit;
import com.adobe.marketing.mobile.DatabaseService;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class AnalyticsHitSchema
extends AbstractHitSchema<AnalyticsHit> {
    private static final String LOG_TAG = AnalyticsHitSchema.class.getSimpleName();
    private static final String HIT_ID_COL_NAME = "ID";
    private static final int HIT_ID_COL_INDEX = 0;
    private static final String HIT_URL_COL_NAME = "URL";
    private static final int HIT_URL_COL_INDEX = 1;
    private static final String HIT_TIMESTAMP_COL_NAME = "TIMESTAMP";
    private static final int HIT_TIMESTAMP_COL_INDEX = 2;
    private static final String HIT_SERVER_COL_NAME = "SERVER";
    private static final int HIT_SERVER_COL_INDEX = 3;
    private static final String HIT_OFFLINE_TRACKING_COL_NAME = "OFFLINETRACKING";
    private static final int HIT_OFFLINE_TRACKING_COL_INDEX = 4;
    private static final String HIT_IS_WAITING_COL_NAME = "ISWAITING";
    private static final int HIT_IS_WAITING_COL_INDEX = 5;
    private static final String HIT_IS_PLACEHOLDER_COL_NAME = "ISPLACEHOLDER";
    private static final int HIT_IS_PLACEHOLDER_COL_INDEX = 6;
    private static final String HIT_AAM_FORWARDING_COL_NAME = "AAMFORWARDING";
    private static final int HIT_AAM_FORWARDING_COL_INDEX = 7;
    private static final String HIT_EVENT_IDENTIFIER_COL_NAME = "UNIQUEEVENTIDENTIFIER";
    private static final int HIT_EVENT_IDENTIFIER_COL_INDEX = 8;

    AnalyticsHitSchema() {
        this.columnConstraints = new ArrayList();
        ArrayList<DatabaseService.Database.ColumnConstraint> idColumnConstraints = new ArrayList<DatabaseService.Database.ColumnConstraint>();
        idColumnConstraints.add(DatabaseService.Database.ColumnConstraint.PRIMARY_KEY);
        idColumnConstraints.add(DatabaseService.Database.ColumnConstraint.AUTOINCREMENT);
        this.columnConstraints.add(idColumnConstraints);
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnConstraints.add(new ArrayList());
        this.columnNames = new String[]{HIT_ID_COL_NAME, HIT_URL_COL_NAME, HIT_TIMESTAMP_COL_NAME, HIT_SERVER_COL_NAME, HIT_OFFLINE_TRACKING_COL_NAME, HIT_IS_WAITING_COL_NAME, HIT_IS_PLACEHOLDER_COL_NAME, HIT_AAM_FORWARDING_COL_NAME, HIT_EVENT_IDENTIFIER_COL_NAME};
        this.columnDataTypes = new DatabaseService.Database.ColumnDataType[]{DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.TEXT, DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.TEXT, DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.INTEGER, DatabaseService.Database.ColumnDataType.TEXT};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnalyticsHit generateHit(DatabaseService.QueryResult queryResult) {
        try {
            AnalyticsHit analyticsHit = new AnalyticsHit();
            analyticsHit.identifier = queryResult.getString(0);
            analyticsHit.url = queryResult.getString(1);
            analyticsHit.timestamp = queryResult.getLong(2);
            analyticsHit.server = queryResult.getString(3);
            analyticsHit.offlineTrackingEnabled = queryResult.getInt(4) == 1;
            analyticsHit.isWaiting = queryResult.getInt(5) == 1;
            analyticsHit.isBackdatePlaceHolder = queryResult.getInt(6) == 1;
            analyticsHit.aamForwardingEnabled = queryResult.getInt(7) == 1;
            analyticsHit.uniqueEventIdentifier = queryResult.getString(8);
            AnalyticsHit analyticsHit2 = analyticsHit;
            return analyticsHit2;
        }
        catch (Exception e) {
            Log.error((String)LOG_TAG, (String)"generateHit - Unable to read from database. Query failed with error %s", (Object[])new Object[]{e});
            AnalyticsHit analyticsHit = null;
            return analyticsHit;
        }
        finally {
            if (queryResult != null) {
                queryResult.close();
            }
        }
    }

    Map<String, Object> generateDataMap(AnalyticsHit hit) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(HIT_URL_COL_NAME, hit.url);
        dataMap.put(HIT_TIMESTAMP_COL_NAME, hit.timestamp);
        dataMap.put(HIT_SERVER_COL_NAME, hit.server);
        dataMap.put(HIT_OFFLINE_TRACKING_COL_NAME, hit.offlineTrackingEnabled);
        dataMap.put(HIT_IS_WAITING_COL_NAME, hit.isWaiting);
        dataMap.put(HIT_IS_PLACEHOLDER_COL_NAME, hit.isBackdatePlaceHolder);
        dataMap.put(HIT_AAM_FORWARDING_COL_NAME, hit.aamForwardingEnabled);
        dataMap.put(HIT_EVENT_IDENTIFIER_COL_NAME, hit.uniqueEventIdentifier);
        return dataMap;
    }

    Query getFirstWaitingHitQuery(String tableName) {
        Query.Builder queryBuilder = new Query.Builder(tableName, this.columnNames);
        queryBuilder.selection("ISWAITING = ?", new String[]{"1"});
        queryBuilder.limit("1");
        queryBuilder.orderBy("ID ASC");
        return queryBuilder.build();
    }

    Query getLatestPlaceHolderHitQuery(String tableName) {
        Query.Builder queryBuilder = new Query.Builder(tableName, this.columnNames);
        queryBuilder.selection("ISPLACEHOLDER = ?", new String[]{"1"});
        queryBuilder.limit("1");
        queryBuilder.orderBy("ID DESC");
        return queryBuilder.build();
    }

    Query getRegularHitQuery(String tableName) {
        Query.Builder queryBuilder = new Query.Builder(tableName, this.columnNames);
        queryBuilder.selection("ISPLACEHOLDER = ?", new String[]{"0"});
        queryBuilder.orderBy("ID DESC");
        return queryBuilder.build();
    }

    Map<String, Object> generateUpdateValuesForResetIsWaitingFlag() {
        HashMap<String, Object> updateValues = new HashMap<String, Object>();
        updateValues.put(HIT_IS_WAITING_COL_NAME, 0);
        return updateValues;
    }

    static Map<String, Object> generateUpdateValuesForServer(String server) {
        HashMap<String, Object> updateValues = new HashMap<String, Object>();
        updateValues.put(HIT_SERVER_COL_NAME, server);
        return updateValues;
    }
}

