/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import com.adobe.marketing.mobile.AbstractHit;
import com.adobe.marketing.mobile.AbstractHitSchema;
import com.adobe.marketing.mobile.AnalyticsDispatcherAnalyticsResponseContent;
import com.adobe.marketing.mobile.AnalyticsHit;
import com.adobe.marketing.mobile.AnalyticsHitSchema;
import com.adobe.marketing.mobile.AnalyticsProperties;
import com.adobe.marketing.mobile.AnalyticsState;
import com.adobe.marketing.mobile.AnalyticsVersionProvider;
import com.adobe.marketing.mobile.ContextDataUtil;
import com.adobe.marketing.mobile.HitQueue;
import com.adobe.marketing.mobile.Log;
import com.adobe.marketing.mobile.MissingPlatformServicesException;
import com.adobe.marketing.mobile.NetworkConnectionUtil;
import com.adobe.marketing.mobile.NetworkService;
import com.adobe.marketing.mobile.PlatformServices;
import com.adobe.marketing.mobile.StringUtils;
import com.adobe.marketing.mobile.SystemInfoService;
import com.adobe.marketing.mobile.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

class AnalyticsHitsDatabase
implements HitQueue.IHitProcessor<AnalyticsHit> {
    private static final String LOG_TAG = AnalyticsHitsDatabase.class.getSimpleName();
    private static final SecureRandom SECURE_RNG = new SecureRandom();
    private static final int RANDOM_INT_BOUND = 100000000;
    private static final int TIMESTAMP_DISABLED_WAIT_THRESHOLD_SECONDS = 60;
    private static final String ANALYTICS_FILENAME = "ADBMobileDataCache.sqlite";
    private static final String ANALYTICS_TABLE_NAME = "HITS";
    private AnalyticsProperties analyticsProperties;
    private NetworkService networkService;
    private SystemInfoService systemInfoService;
    private AnalyticsDispatcherAnalyticsResponseContent analyticsResponseDispatcher;
    private AnalyticsHitSchema analyticsHitSchema;
    private HitQueue<AnalyticsHit, AnalyticsHitSchema> hitQueue;
    private AnalyticsState previousState;
    long lastHitTimestampInSeconds;

    AnalyticsHitsDatabase(PlatformServices services, AnalyticsProperties properties, AnalyticsDispatcherAnalyticsResponseContent dispatcher) throws MissingPlatformServicesException {
        this.analyticsProperties = properties;
        this.analyticsResponseDispatcher = dispatcher;
        this.networkService = services.getNetworkService();
        this.systemInfoService = services.getSystemInfoService();
        this.analyticsHitSchema = new AnalyticsHitSchema();
        if (this.systemInfoService == null || this.networkService == null) {
            throw new MissingPlatformServicesException("Missing platform service (SystemInfoService and/or NetworkService)");
        }
        File directory = this.systemInfoService.getApplicationCacheDir();
        File dbFilePath = new File(directory, ANALYTICS_FILENAME);
        this.hitQueue = new HitQueue(services, dbFilePath, ANALYTICS_TABLE_NAME, (AbstractHitSchema)this.analyticsHitSchema, (HitQueue.IHitProcessor)this);
        this.lastHitTimestampInSeconds = 0L;
    }

    AnalyticsHitsDatabase(PlatformServices services, AnalyticsProperties properties, AnalyticsDispatcherAnalyticsResponseContent dispatcher, HitQueue<AnalyticsHit, AnalyticsHitSchema> hitQueue) throws MissingPlatformServicesException {
        this(services, properties, dispatcher);
        this.hitQueue = hitQueue;
    }

    public HitQueue.RetryType process(AnalyticsHit hit) {
        if (this.analyticsProperties.isDatabaseWaiting()) {
            return HitQueue.RetryType.WAIT;
        }
        if (hit.isBackdatePlaceHolder) {
            return HitQueue.RetryType.NO;
        }
        if (StringUtils.isNullOrEmpty((String)hit.server)) {
            return HitQueue.RetryType.YES;
        }
        if (hit.timestamp < this.analyticsProperties.getLastResetIdentitiesTimestamp()) {
            Log.debug((String)LOG_TAG, (String)"process - Dropping Analytics hit, resetIdentities API was called after this request.", (Object[])new Object[0]);
            return HitQueue.RetryType.NO;
        }
        if (hit.offlineTrackingEnabled && hit.timestamp - this.lastHitTimestampInSeconds < 0L) {
            this.updateTimestampIfNeeded(hit, this.lastHitTimestampInSeconds);
        }
        if (!hit.offlineTrackingEnabled && hit.timestamp < TimeUtil.getUnixTimeInSeconds() - 60L) {
            return HitQueue.RetryType.NO;
        }
        String postBody = hit.url.startsWith("ndh") ? hit.url : hit.url.substring(hit.url.indexOf(63) + 1);
        AnalyticsState stateToUse = this.previousState;
        String finalPostBody = postBody;
        if (stateToUse != null && stateToUse.isAssuranceSessionActive()) {
            finalPostBody = finalPostBody + "&p.&debug=true&.p";
            hit.url = hit.url + "&p.&debug=true&.p";
        }
        NetworkService.HttpConnection connection = this.sendAnalyticsHitToServer(hit.server, finalPostBody);
        return this.handleNetworkConnection(connection, hit);
    }

    void kickWithAdditionalData(AnalyticsState state, Map<String, String> additionalData) {
        Log.trace((String)LOG_TAG, (String)"kickWithAdditionalData - Additional data was received, trying to kick Analytics queue.", (Object[])new Object[0]);
        if (additionalData == null || additionalData.isEmpty()) {
            this.kick(state, false);
            return;
        }
        AnalyticsHit hit = (AnalyticsHit)this.hitQueue.queryHit(this.analyticsHitSchema.getFirstWaitingHitQuery(ANALYTICS_TABLE_NAME));
        if (hit != null && hit.url != null) {
            hit.url = ContextDataUtil.appendContextData(additionalData, (String)hit.url);
            this.hitQueue.updateHit((AbstractHit)hit);
        }
        this.kick(state, false);
        if (state != null) {
            this.previousState = state;
        }
    }

    void updateBackdatedHit(AnalyticsState state, String dataString, long timestamp, String uniqueEventIdentifier) {
        Log.debug((String)LOG_TAG, (String)"updateBackdatedHit - Backdated session info received.", (Object[])new Object[0]);
        AnalyticsHit hit = (AnalyticsHit)this.hitQueue.queryHit(this.analyticsHitSchema.getLatestPlaceHolderHitQuery(ANALYTICS_TABLE_NAME));
        if (hit != null && hit.url != null) {
            hit.url = dataString;
            hit.timestamp = timestamp;
            hit.isBackdatePlaceHolder = false;
            String sdkVersion = AnalyticsVersionProvider.getVersion();
            hit.server = state.getBaseURL(sdkVersion);
            hit.offlineTrackingEnabled = state.isOfflineTrackingEnabled();
            hit.aamForwardingEnabled = state.isAnalyticsForwardingEnabled();
            hit.uniqueEventIdentifier = uniqueEventIdentifier;
            this.hitQueue.updateHit((AbstractHit)hit);
        }
        this.kick(state, false);
        if (state != null) {
            this.previousState = state;
        }
    }

    boolean isHitWaiting() {
        return this.hitQueue.queryHit(this.analyticsHitSchema.getFirstWaitingHitQuery(ANALYTICS_TABLE_NAME)) != null;
    }

    void queue(AnalyticsState state, String url, long timeStampInSeconds, boolean shouldBeWaiting, boolean isBackdatedPlaceholder, String uniqueEventIdentifier) {
        AnalyticsHit analyticsHit = new AnalyticsHit();
        analyticsHit.url = url;
        analyticsHit.timestamp = timeStampInSeconds;
        String sdkVersion = AnalyticsVersionProvider.getVersion();
        analyticsHit.server = state != null ? state.getBaseURL(sdkVersion) : "";
        analyticsHit.offlineTrackingEnabled = state == null || state.isOfflineTrackingEnabled();
        analyticsHit.aamForwardingEnabled = state == null || state.isAnalyticsForwardingEnabled();
        analyticsHit.isWaiting = shouldBeWaiting;
        analyticsHit.isBackdatePlaceHolder = isBackdatedPlaceholder;
        analyticsHit.uniqueEventIdentifier = uniqueEventIdentifier;
        if (!this.hitQueue.queue((AbstractHit)analyticsHit)) {
            Log.debug((String)LOG_TAG, (String)"queue - AnalyticsExtension hit queue failed (%s)", (Object[])new Object[]{analyticsHit.url});
        } else {
            Log.debug((String)LOG_TAG, (String)"queue - AnalyticsExtension hit queued (%s)", (Object[])new Object[]{url});
        }
        if (state != null && !StringUtils.isNullOrEmpty((String)analyticsHit.server)) {
            this.kick(state, false);
        }
        if (state != null) {
            this.previousState = state;
        }
    }

    void forceKick(AnalyticsState state) {
        Log.debug((String)LOG_TAG, (String)"forceKick - Force Kicking database hits.", (Object[])new Object[0]);
        this.kick(state, true);
    }

    void kick(AnalyticsState state, boolean ignoreBatchLimit) {
        String sdkVersion;
        String baseURL;
        boolean overBatchLimit;
        AnalyticsState stateToUse;
        if (this.analyticsProperties.isDatabaseWaiting()) {
            Log.debug((String)LOG_TAG, (String)"kick - Failed to kick database hits as Database not ready", (Object[])new Object[0]);
            return;
        }
        AnalyticsState analyticsState = stateToUse = state == null ? this.previousState : state;
        if (stateToUse == null) {
            Log.debug((String)LOG_TAG, (String)"kick - Failed to kick database hits as Analytics state is null.", (Object[])new Object[0]);
            return;
        }
        if (!stateToUse.isOptIn()) {
            Log.debug((String)LOG_TAG, (String)"kick - Failed to kick database hits as Privacy status is not opted-in.", (Object[])new Object[0]);
            return;
        }
        boolean bl = overBatchLimit = !stateToUse.isOfflineTrackingEnabled() || this.getTrackingQueueSize() > (long)stateToUse.getBatchLimit();
        if ((overBatchLimit || ignoreBatchLimit) && !StringUtils.isNullOrEmpty((String)(baseURL = stateToUse.getBaseURL(sdkVersion = AnalyticsVersionProvider.getVersion())))) {
            Log.debug((String)LOG_TAG, (String)"kick - Bring Analytics tracking online as it is over batch limit or offline tracking is not enabled", (Object[])new Object[0]);
            this.hitQueue.updateAllHits(AnalyticsHitSchema.generateUpdateValuesForServer(baseURL));
            this.hitQueue.bringOnline();
        }
        if (stateToUse != null) {
            this.previousState = stateToUse;
        }
    }

    protected void clearTrackingQueue() {
        this.hitQueue.deleteAllHits();
    }

    protected long getTrackingQueueSize() {
        return this.hitQueue.getSize(this.analyticsHitSchema.getRegularHitQuery(ANALYTICS_TABLE_NAME));
    }

    protected void resetIsWaitingFlag() {
        Map<String, Object> updateValues = this.analyticsHitSchema.generateUpdateValuesForResetIsWaitingFlag();
        this.hitQueue.updateAllHits(updateValues);
    }

    private NetworkService.HttpConnection sendAnalyticsHitToServer(String baseURL, String postBody) {
        String url = baseURL + SECURE_RNG.nextInt(100000000);
        byte[] payload = postBody != null ? postBody.getBytes(Charset.forName("UTF-8")) : null;
        Log.debug((String)LOG_TAG, (String)"sendAnalyticsHitToServer - AnalyticsExtension request was sent with body (%s)", (Object[])new Object[]{postBody});
        return this.networkService.connectUrl(url, NetworkService.HttpCommand.POST, payload, NetworkConnectionUtil.getHeaders((boolean)true), 5, 5);
    }

    private HitQueue.RetryType handleNetworkConnection(NetworkService.HttpConnection connection, AnalyticsHit hit) {
        if (connection == null) {
            return HitQueue.RetryType.YES;
        }
        HitQueue.RetryType retryType = HitQueue.RetryType.NO;
        if (connection.getResponseCode() == 200) {
            try {
                String response = NetworkConnectionUtil.readFromInputStream((InputStream)connection.getInputStream());
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("ETag", connection.getResponsePropertyValue("ETag"));
                headers.put("Server", connection.getResponsePropertyValue("Server"));
                headers.put("Content-Type", connection.getResponsePropertyValue("Content-Type"));
                if (hit.timestamp > this.analyticsProperties.getLastResetIdentitiesTimestamp()) {
                    this.analyticsResponseDispatcher.dispatchAnalyticsHitResponse(response, headers, hit.uniqueEventIdentifier, hit.server, hit.url);
                }
                this.lastHitTimestampInSeconds = hit.timestamp;
            }
            catch (IOException e) {
                Log.warning((String)LOG_TAG, (String)"handleNetworkConnection - Couldn't read server response, failed with error (%s)", (Object[])new Object[]{e});
                retryType = HitQueue.RetryType.NO;
            }
        } else if (connection.getResponseCode() == -1) {
            retryType = HitQueue.RetryType.YES;
        }
        connection.close();
        return retryType;
    }

    private void updateTimestampIfNeeded(AnalyticsHit hit, long lastHitTimestamp) {
        long delta = hit.timestamp - lastHitTimestamp;
        if (delta < 0L) {
            long newTimestamp = lastHitTimestamp + 1L;
            String oldTSString = "&ts=" + Long.toString(hit.timestamp);
            String newTSString = "&ts=" + Long.toString(newTimestamp);
            Log.debug((String)LOG_TAG, (String)"updateTimestampIfNeeded - Adjusting out of order hit timestamp (%d->%d)", (Object[])new Object[]{hit.timestamp, newTimestamp});
            hit.timestamp = newTimestamp;
            hit.url = hit.url.replaceFirst(oldTSString, newTSString);
        }
    }
}

